/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.INBTSerializable;

public interface IEmitter
extends IRelatedUnit,
IPostInit {
    public static final Predicate<String> COMMON_ACTIVE_TAG_NAME = name -> Arrays.asList("active", "lit", "fuel", "enabled", "burn", "cook", "work", "process", "progress", "operat", "combust", "run", "rotat", "tick", "ison").stream().anyMatch(e -> name.toLowerCase(Locale.ROOT).contains((CharSequence)e));
    public static final String COMMENT_ACTIVE_STATE_TAG = "Defines the name of the NBT tag that stores info about tile entity active state.\nEmitter is considered active if the return value is greater than 0 or true.\nSet to an empty string if you don't need this function.";
    public static final String COMMENT_IDENTITY_TAG = "This parameter is required only for those blocks that use NBT tags to fully identify themselves.\nThe format is <tagKey>=<value>\nIf the value is a string, it must be enclosed in double quotes. Example: id=\"ic2:generator\"\nLeave this blank if you don't need it.";
    public static final String COMMENT_TYPE = "Defines the type of this emitter.\nValid types (case insensitive):\n  BLOCK - a simple Block without a Tile Entity that will be updated each time it receives a random tick.\n  TILE - a Block with a Tile Entity that will be updated onces per second.\n  ENTITY - a mobile Entity that will be updated onces per second.\n  FUEL - a Tile Entity with a HARDCODED hook that will be updated each time it consumes fuel.";
    public static final String COMMENT_RELATED_BLOCKS = "Defines a list of blocks which should be considered as part of this multiblock.";
    public static final String TAG_HARDCODED = "#hardcoded";

    public String getActiveTag();

    public KeyValuePair getIdentityTag();

    public Type getType();

    public Set<BlockState> getRelatedBlocks();

    default public boolean isActive(IWorldReader world, BlockPos pos) {
        switch (this.getType()) {
            case BLOCK: {
                return true;
            }
            case TILE: 
            case FUEL: {
                TileEntity tile = world.func_175625_s(pos);
                return this.isActive((INBTSerializable<CompoundNBT>)tile);
            }
        }
        return false;
    }

    default public boolean isActive(@Nullable INBTSerializable<CompoundNBT> nbtSource) {
        String tag = this.getActiveTag();
        if (tag == null || tag.isEmpty()) {
            return true;
        }
        if (nbtSource == null) {
            return false;
        }
        CompoundNBT compound = (CompoundNBT)nbtSource.serializeNBT();
        ForgeNBT.KeyPathPair pair = ForgeNBT.KeyPathPair.from(tag);
        if ((compound = ForgeNBT.getNestedCompound(compound, pair.path)) != null) {
            int intValue = compound.func_74762_e(pair.key);
            return intValue > 0;
        }
        return false;
    }

    default public boolean isIdentified(@Nullable INBTSerializable<CompoundNBT> nbtSource) {
        ForgeNBT.KeyPathPair pair;
        KeyValuePair id = this.getIdentityTag();
        if (id == null || id.key.isEmpty()) {
            return true;
        }
        if (nbtSource == null) {
            return false;
        }
        CompoundNBT compound = (CompoundNBT)nbtSource.serializeNBT();
        INBT tag = ForgeNBT.getTag(compound, pair = ForgeNBT.KeyPathPair.from(id.key));
        if (tag == null) {
            return false;
        }
        if (id.value.isEmpty()) {
            return true;
        }
        return id.value.equals(tag.toString());
    }

    public static enum Type {
        BLOCK,
        TILE,
        ENTITY,
        FUEL;


        public boolean isBlock() {
            return this == BLOCK;
        }

        public boolean isTile() {
            return this == TILE;
        }

        public boolean isEntity() {
            return this == ENTITY;
        }

        public boolean isFuel() {
            return this == FUEL;
        }

        public static Optional<Type> getByName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }

        public static Type getFrom(UnitConfig config, String category, Type defaultValue, String comment) {
            String name = UnitConfig.getStr(config, category, "type", defaultValue.name(), comment);
            Optional<Type> type = Type.getByName(name);
            if (type.isPresent()) {
                return type.get();
            }
            ForgeEndertech.getInstance().getLogger().error("Invalid emitter type = '" + name + "'" + config != null ? " in " + config.getConfigFile().toString() : "");
            return defaultValue;
        }
    }
}

