/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeId {
    public static final BiomeId EMPTY = new BiomeId(Optional.empty());
    protected final Optional<RegistryKey<Biome>> key;

    protected BiomeId(Optional<RegistryKey<Biome>> registryKey) {
        this.key = registryKey;
    }

    public static BiomeId from(RegistryKey<Biome> registryKey) {
        return new BiomeId(Optional.of(registryKey));
    }

    public static BiomeId from(IWorld world, BlockPos pos) {
        return new BiomeId(world.func_242406_i(pos));
    }

    public static BiomeId from(ResourceLocation location) {
        Optional<RegistryKey<Biome>> registryKey = ForgeRegistries.BIOMES.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().equals((Object)location)).findFirst().map(entry -> (RegistryKey)entry.getKey());
        return new BiomeId(registryKey);
    }

    public boolean isEmpty() {
        return !this.getKey().isPresent();
    }

    public Optional<RegistryKey<Biome>> getKey() {
        return this.key;
    }

    public Optional<ResourceLocation> getResourceLocation() {
        return this.getKey().map(key -> key.func_240901_a_());
    }

    public Optional<Biome> getBiome() {
        return this.getResourceLocation().map(key -> (Biome)ForgeRegistries.BIOMES.getValue(key));
    }

    public String toString() {
        return this.getResourceLocation().map(loc -> loc.toString()).orElse(super.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeId) {
            return Objects.equals(this.getKey(), ((BiomeId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

