/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EquipmentItem
extends DamageableItem {
    private final EquipmentSlotType equipmentSlot;
    @Nullable
    private final SoundEvent equipSound;

    public EquipmentItem(ForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, UnitId repairItem, EquipmentSlotType equipSlot, @Nullable SoundEvent equipSound) {
        super(mod, config, name, props, durability, repairItem);
        this.equipmentSlot = equipSlot;
        this.equipSound = equipSound;
    }

    public EquipmentSlotType getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nullable
    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == this.getEquipmentSlot();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        ItemStack headSlot = player.func_184582_a(this.getEquipmentSlot());
        if (headSlot.func_190926_b()) {
            player.func_184201_a(this.getEquipmentSlot(), heldStack.func_77946_l());
            heldStack.func_190920_e(0);
            if (this.getEquipSound() != null) {
                player.func_184185_a(this.getEquipSound(), 1.0f, 1.0f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
    }
}

