/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ChestWearItemRenderer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    public ChestWearItemRenderer(IEntityRenderer<T, M> entityRenderer) {
        super(entityRenderer);
    }

    public ModelRenderer getChestRenderer() {
        return ((BipedModel)this.func_215332_c()).field_78115_e;
    }

    public abstract boolean shouldRender(ItemStack var1, T var2);

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = living.func_184582_a(EquipmentSlotType.CHEST);
        if (!this.shouldRender(stack, living)) {
            return;
        }
        matrixStack.func_227860_a_();
        if (living.func_70631_g_() && !(living instanceof VillagerEntity)) {
            matrixStack.func_227861_a_(0.0, 0.03125, 0.0);
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
            matrixStack.func_227861_a_(0.0, 1.0, 0.0);
        }
        this.getChestRenderer().func_228307_a_(matrixStack);
        matrixStack.func_227861_a_(0.0, -0.25, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227862_a_(0.625f, -0.625f, -0.625f);
        if (living instanceof VillagerEntity || living instanceof ZombieVillagerEntity) {
            matrixStack.func_227861_a_(0.0, 0.1875, 0.0);
        }
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(living, stack, ItemCameraTransforms.TransformType.HEAD, false, matrixStack, buffer, packedLight);
        matrixStack.func_227865_b_();
    }
}

