/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class GameKeys {
    protected static final String KEY = "key";
    protected static final String CATEGORIES = "categories";
    protected static final String DELIMITER = ".";

    public static boolean affectPlayer() {
        return Minecraft.func_71410_x().field_71462_r == null;
    }

    public static boolean affectMenus() {
        return !GameKeys.affectPlayer();
    }

    public static GameSettings getGameSettings() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    public static MainWindow getMainWindow() {
        return Minecraft.func_71410_x().func_228018_at_();
    }

    public static boolean isShiftDown() {
        long handle = GameKeys.getMainWindow().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }

    public static boolean isControlDown() {
        long handle = GameKeys.getMainWindow().func_198092_i();
        if (Minecraft.field_142025_a) {
            return InputMappings.func_216506_a((long)handle, (int)343) || InputMappings.func_216506_a((long)handle, (int)347);
        }
        return InputMappings.func_216506_a((long)handle, (int)341) || InputMappings.func_216506_a((long)handle, (int)345);
    }

    public static boolean isDown(int GLFW_KeyCode) {
        if (GLFW_KeyCode == -1) {
            return false;
        }
        if (GLFW_KeyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)GameKeys.getMainWindow().func_198092_i(), (int)GLFW_KeyCode) == 1;
        }
        if (GLFW_KeyCode >= 32 && GLFW_KeyCode <= 348) {
            return GLFW.glfwGetKey((long)GameKeys.getMainWindow().func_198092_i(), (int)GLFW_KeyCode) == 1;
        }
        return false;
    }

    public static boolean isAltDown() {
        long handle = GameKeys.getMainWindow().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)342) || InputMappings.func_216506_a((long)handle, (int)346);
    }

    public static KeyBinding createBindingFor(ResourceLocation actionName, int keyCode, KeyCategories keyCategory) {
        KeyBinding keyBinding = new KeyBinding(Args.joinDelim(DELIMITER, "keybind", actionName.func_110624_b(), actionName.func_110623_a()), keyCode, keyCategory.getName());
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    public static enum KeyCategories implements IForgeEnum
    {
        NONE,
        MOVEMENT,
        GAMEPLAY,
        INVENTORY,
        CREATIVE,
        MULTIPLAYER,
        UI,
        MISC;


        @Override
        public String getName() {
            return Args.joinDelim(GameKeys.DELIMITER, GameKeys.KEY, GameKeys.CATEGORIES, IForgeEnum.super.getName());
        }
    }
}

