/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.material;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.Pair;
import com.jozufozu.flywheel.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;

public class InstanceMaterial<D extends InstanceData> {
    protected final Cache<Object, Instancer<D>> models;
    protected final MaterialSpec<D> spec;

    public InstanceMaterial(MaterialSpec<D> spec) {
        this.spec = spec;
        this.models = CacheBuilder.newBuilder().removalListener(notification -> {
            Instancer instancer = (Instancer)notification.getValue();
            RenderWork.enqueue(instancer::delete);
        }).build();
    }

    public Instancer<D> model(Object key, Supplier<IModel> modelSupplier) {
        try {
            return (Instancer)this.models.get(key, () -> new Instancer<D>(modelSupplier, this.spec));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("error creating instancer", e);
        }
    }

    public Instancer<D> getModel(PartialModel partial, BlockState referenceState) {
        return this.model(partial, () -> new BlockModel(this.spec.getModelFormat(), partial.get(), referenceState));
    }

    public Instancer<D> getModel(PartialModel partial, BlockState referenceState, Direction dir) {
        return this.getModel(partial, referenceState, dir, RenderUtil.rotateToFace(dir));
    }

    public Instancer<D> getModel(PartialModel partial, BlockState referenceState, Direction dir, Supplier<MatrixStack> modelTransform) {
        return this.model(Pair.of(dir, partial), () -> new BlockModel(this.spec.getModelFormat(), partial.get(), referenceState, (MatrixStack)modelTransform.get()));
    }

    public Instancer<D> getModel(BlockState toRender) {
        return this.model(toRender, () -> new BlockModel(this.spec.getModelFormat(), toRender));
    }

    public boolean nothingToRender() {
        return this.models.size() > 0L && this.models.asMap().values().stream().allMatch(Instancer::isEmpty);
    }

    public void delete() {
        this.models.invalidateAll();
    }

    public void clear() {
        this.models.asMap().values().forEach(Instancer::clear);
    }

    public void forEachInstancer(Consumer<Instancer<D>> f) {
        for (Instancer model : this.models.asMap().values()) {
            f.accept(model);
        }
    }
}

