/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.loading;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.Shader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class Program {
    public final ResourceLocation name;
    public final int program;
    private int attributeIndex;
    public final Map<ShaderType, Shader> attached;
    private final IntList shaders;

    public Program(ResourceLocation name) {
        this.name = name;
        this.program = GL20.glCreateProgram();
        this.attached = new EnumMap<ShaderType, Shader>(ShaderType.class);
        this.shaders = new IntArrayList(2);
    }

    public Program attachShader(Shader shader, GlShader glShader) {
        GL20.glAttachShader((int)this.program, (int)glShader.handle());
        this.attached.put(shader.type, shader);
        return this;
    }

    public Program addAttribute(String name, int attributeCount) {
        GL20.glBindAttribLocation((int)this.program, (int)this.attributeIndex, (CharSequence)name);
        this.attributeIndex += attributeCount;
        return this;
    }

    public Program link() {
        int result;
        GL20.glLinkProgram((int)this.program);
        String log = GL20.glGetProgramInfoLog((int)this.program);
        if (!log.isEmpty()) {
            Backend.log.debug("Program link log for " + this.name + ": " + log);
        }
        if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return this;
    }

    public Program deleteLinkedShaders() {
        this.shaders.forEach(GL20::glDeleteShader);
        return this;
    }
}

