/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import net.minecraftforge.common.util.Lazy;
import org.lwjgl.opengl.GL20;

public class FullscreenQuad {
    public static final Lazy<FullscreenQuad> INSTANCE = Lazy.of(FullscreenQuad::new);
    private static final float[] vertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final int bufferSize = vertices.length * 4;
    private final GlVertexArray vao;
    private final GlBuffer vbo = new GlBuffer(GlBufferType.ARRAY_BUFFER);

    private FullscreenQuad() {
        this.vbo.bind();
        this.vbo.alloc(bufferSize);
        this.vbo.getBuffer(0, bufferSize).putFloatArray(vertices).flush();
        this.vao = new GlVertexArray();
        this.vao.bind();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)4, (int)GlNumericType.FLOAT.getGlEnum(), (boolean)false, (int)16, (long)0L);
        this.vao.unbind();
        this.vbo.unbind();
    }

    public void draw() {
        this.vao.bind();
        GL20.glDrawArrays((int)4, (int)0, (int)6);
        this.vao.unbind();
    }

    public void delete() {
        this.vao.delete();
        this.vbo.delete();
    }
}

