/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.material;

import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.material.InstanceMaterial;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.backend.material.MaterialRenderer;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.backend.state.IRenderState;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.vector.Matrix4f;

public class MaterialGroup<P extends WorldProgram> {
    protected final MaterialManager<P> owner;
    protected final IRenderState state;
    private final ArrayList<MaterialRenderer<P>> renderers = new ArrayList();
    private final Map<MaterialSpec<?>, InstanceMaterial<?>> materials = new HashMap();

    public MaterialGroup(MaterialManager<P> owner, IRenderState state) {
        this.owner = owner;
        this.state = state;
    }

    public <D extends InstanceData> InstanceMaterial<D> material(MaterialSpec<D> spec) {
        return this.materials.computeIfAbsent(spec, this::createInstanceMaterial);
    }

    public void render(Matrix4f viewProjection, double camX, double camY, double camZ) {
        for (MaterialRenderer<P> renderer : this.renderers) {
            renderer.render(viewProjection, camX, camY, camZ);
        }
    }

    public void setup(P program) {
    }

    public void clear() {
        this.materials.values().forEach(InstanceMaterial::clear);
    }

    public void delete() {
        this.materials.values().forEach(InstanceMaterial::delete);
        this.materials.clear();
        this.renderers.clear();
    }

    private InstanceMaterial<?> createInstanceMaterial(MaterialSpec<?> type) {
        InstanceMaterial material = new InstanceMaterial(type);
        this.renderers.add(new MaterialRenderer<WorldProgram>(this.owner.getProgram(type.getProgramName()), material, this::setup));
        return material;
    }
}

