/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.common.connection.transfer.BasicTransferHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public class FluxStorageHandler
extends BasicTransferHandler<TileFluxStorage> {
    private long added;
    private long removed;

    public FluxStorageHandler(TileFluxStorage fluxStorage) {
        super(fluxStorage);
    }

    @Override
    public void onCycleStart() {
    }

    @Override
    public void onCycleEnd() {
        this.change = this.added - this.removed;
        this.added = 0L;
        this.removed = 0L;
    }

    @Override
    public void addToBuffer(long energy) {
        if (energy <= 0L) {
            return;
        }
        this.buffer += energy;
        this.added += energy;
        ((TileFluxStorage)this.device).markServerEnergyChanged();
    }

    @Override
    public long removeFromBuffer(long energy) {
        long a = Math.min(Math.min(energy, this.buffer), ((TileFluxStorage)this.device).getLogicLimit() - this.removed);
        if (a <= 0L) {
            return 0L;
        }
        this.buffer -= a;
        this.removed += a;
        ((TileFluxStorage)this.device).markServerEnergyChanged();
        return a;
    }

    @Override
    public long getRequest() {
        return Math.max(0L, Math.min(((TileFluxStorage)this.device).getMaxTransferLimit() - this.buffer, ((TileFluxStorage)this.device).getLogicLimit() - this.added));
    }

    @Override
    public void writeCustomNBT(CompoundNBT tag, int type) {
        if (type == 11 || type == 20) {
            super.writeCustomNBT(tag, type);
        }
        if (type == 1 || type == 15) {
            tag.func_74772_a("energy", this.buffer);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT tag, int type) {
        if (type == 11) {
            super.readCustomNBT(tag, type);
        }
        if (type == 1 || type == 15) {
            this.buffer = tag.func_74763_f("energy");
        }
    }

    @Override
    public void writePacket(@Nonnull PacketBuffer buffer, byte id) {
        if (id == -2) {
            buffer.writeLong(this.buffer);
        } else {
            super.writePacket(buffer, id);
        }
    }

    @Override
    public void readPacket(@Nonnull PacketBuffer buffer, byte id) {
        if (id == -2) {
            this.buffer = buffer.readLong();
        } else {
            super.readPacket(buffer, id);
        }
    }

    @Override
    public void updateTransfers(Direction ... faces) {
    }
}

