/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.StringTextComponent;

public class FluxTextWidget
extends TextFieldWidget {
    private String origin;
    private String extraText;
    private int textWidth;
    private boolean hexOnly;
    private FontRenderer font;
    private boolean digitsOnly;
    private long maxValue = Integer.MAX_VALUE;
    private boolean allowNegatives = false;
    private int outlineColor = -4934476;

    public FluxTextWidget(String text, FontRenderer fontRenderer, int x, int y, int totalWidth, int height, int headerWidth) {
        super(fontRenderer, x + headerWidth, y, totalWidth - headerWidth, height, StringTextComponent.field_240750_d_);
        this.extraText = text;
        this.textWidth = headerWidth;
        this.font = fontRenderer;
    }

    public static FluxTextWidget create(String text, FontRenderer fontRenderer, int x, int y, int width, int height) {
        return new FluxTextWidget(text, fontRenderer, x, y, width, height, fontRenderer.func_78256_a(text));
    }

    public int getIntegerFromText(boolean allowNegatives) {
        if (this.func_146179_b().isEmpty() || this.func_146179_b().equals("-")) {
            return 0;
        }
        int parseInt = Integer.parseInt(this.func_146179_b());
        return allowNegatives ? parseInt : Math.max(parseInt, 0);
    }

    public long getLongFromText(boolean allowNegatives) {
        if (this.func_146179_b().isEmpty() || this.func_146179_b().equals("-")) {
            return 0L;
        }
        long parseLong = Long.parseLong(this.func_146179_b());
        return allowNegatives ? parseLong : Math.max(parseLong, 0L);
    }

    public int getIntegerFromHex() {
        return Integer.parseInt(this.func_146179_b(), 16);
    }

    public void func_230431_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.func_146176_q()) {
            FluxTextWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - this.textWidth - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)this.field_230691_m_, (int)this.outlineColor);
            FluxTextWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - this.textWidth - 1), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)this.outlineColor);
            FluxTextWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - this.textWidth - 1), (int)this.field_230691_m_, (int)(this.field_230690_l_ - this.textWidth), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.outlineColor);
            FluxTextWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_), (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.outlineColor);
            FluxTextWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - this.textWidth), (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0x20000000);
        }
        this.field_230690_l_ += 4;
        this.field_230691_m_ += (this.field_230689_k_ - 8) / 2;
        this.func_146185_a(false);
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        this.font.func_238421_b_(matrixStack, this.extraText, (float)(this.field_230690_l_ - this.textWidth), (float)this.field_230691_m_, this.outlineColor);
        this.field_230690_l_ -= 4;
        this.field_230691_m_ -= (this.field_230689_k_ - 8) / 2;
    }

    public void func_146191_b(@Nonnull String textToWrite) {
        char c;
        int i;
        if (this.digitsOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (Character.isDigit(c)) continue;
                if (this.func_146179_b().isEmpty()) {
                    if (c == '-') continue;
                    return;
                }
                return;
            }
        }
        if (this.hexOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (c != '-') continue;
                return;
            }
            String origin = this.func_146179_b();
            super.func_146191_b(textToWrite);
            try {
                Integer.parseInt(this.func_146179_b(), 16);
            }
            catch (NumberFormatException ignored) {
                this.func_146180_a(origin);
            }
            return;
        }
        super.func_146191_b(textToWrite);
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (this.digitsOnly) {
            if (isFocusedIn) {
                this.origin = this.func_146179_b();
            } else {
                try {
                    this.func_146180_a(String.valueOf(this.getValidLong()));
                }
                catch (NumberFormatException ignored) {
                    this.func_146180_a(this.origin);
                    System.out.println(ignored.getMessage());
                }
            }
        }
    }

    public long getValidLong() {
        return Math.min(this.getLongFromText(this.allowNegatives), this.maxValue);
    }

    public int getValidInt() {
        return (int)Math.min(this.getValidLong(), Integer.MAX_VALUE);
    }

    public FluxTextWidget setOutlineColor(int color) {
        this.outlineColor = color;
        return this;
    }

    public FluxTextWidget setTextInvisible() {
        return this;
    }

    public FluxTextWidget setDigitsOnly() {
        this.digitsOnly = true;
        return this;
    }

    public FluxTextWidget setAllowNegatives(boolean allowNegatives) {
        this.allowNegatives = allowNegatives;
        return this;
    }

    public FluxTextWidget setMaxValue(long max) {
        this.maxValue = max;
        return this;
    }

    public FluxTextWidget setHexOnly() {
        this.hexOnly = true;
        return this;
    }
}

