/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.misc;

import net.minecraft.util.Direction;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public class DefaultEnergyWrapper
implements IEnergyStorage,
IFNEnergyStorage {
    private final IFluxDevice device;
    private final Direction side;

    public DefaultEnergyWrapper(IFluxDevice device, Direction side) {
        this.device = device;
        this.side = side;
    }

    @Override
    public long receiveEnergyL(long maxReceive, boolean simulate) {
        if (this.device.getDeviceType().isPlug() && this.device.isActive()) {
            return this.device.getTransferHandler().receiveFromSupplier(maxReceive, this.side, simulate);
        }
        return 0L;
    }

    @Override
    public long extractEnergyL(long maxExtract, boolean simulate) {
        return 0L;
    }

    @Override
    public long getEnergyStoredL() {
        return this.device.getTransferBuffer();
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.device.getMaxTransferLimit();
    }

    @Override
    public boolean canExtractL() {
        return false;
    }

    @Override
    public boolean canReceiveL() {
        return this.device.getDeviceType().isPlug();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.device.getDeviceType().isPlug() && this.device.isActive()) {
            return (int)this.device.getTransferHandler().receiveFromSupplier(maxReceive, this.side, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.device.getTransferBuffer(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.device.getMaxTransferLimit(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.device.getDeviceType().isPlug();
    }
}

