/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.management.OpEntry;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.misc.FluxCapabilities;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class SuperAdmin
implements ISuperAdmin {
    public static final ResourceLocation CAP_KEY = new ResourceLocation("fluxnetworks", "super_admin");
    private byte permission;

    @Override
    public void changePermission() {
        this.permission = (byte)(this.permission ^ 1);
    }

    @Override
    public boolean hasPermission() {
        return this.permission != 0;
    }

    @Override
    public ByteNBT writeNBT() {
        return ByteNBT.func_229671_a_((byte)this.permission);
    }

    @Override
    public void readNBT(@Nonnull ByteNBT nbt) {
        this.permission = nbt.func_150290_f();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ISuperAdmin.class, (Capability.IStorage)new SuperAdminStorage(), SuperAdmin::new);
    }

    public static boolean canActivateSuperAdmin(PlayerEntity player) {
        if (ServerLifecycleHooks.getCurrentServer().func_71264_H()) {
            return true;
        }
        if (FluxConfig.enableSuperAdmin) {
            OpEntry opEntry = (OpEntry)ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
            return opEntry != null && opEntry.func_152644_a() >= FluxConfig.superAdminRequiredPermission;
        }
        return false;
    }

    public static boolean isPlayerSuperAdmin(@Nonnull PlayerEntity player) {
        ISuperAdmin instance = (ISuperAdmin)FluxUtils.get(player.getCapability(FluxCapabilities.SUPER_ADMIN));
        return instance != null && instance.hasPermission();
    }

    private static class SuperAdminStorage
    implements Capability.IStorage<ISuperAdmin> {
        private SuperAdminStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<ISuperAdmin> capability, @Nonnull ISuperAdmin instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ISuperAdmin> capability, @Nonnull ISuperAdmin instance, Direction side, @Nonnull INBT nbt) {
            if (nbt.func_225647_b_() == ByteNBT.field_229668_a_) {
                instance.readNBT((ByteNBT)nbt);
            }
        }
    }
}

