/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InventoryButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.register.NetworkHandler;

public class GuiTabWireless
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public List<InventoryButton> inventoryButtonList = new ArrayList<InventoryButton>();
    public NormalButton apply;
    public int wirelessMode;

    public GuiTabWireless(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_WIRELESS;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.networkValid) {
            int color = this.network.getNetworkColor();
            this.drawCenterText(matrixStack, FluxTranslate.TAB_WIRELESS.t(), 88.0f, 12.0f, 0xB4B4B4);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.ENABLE_WIRELESS.t(), 20.0f, 156.0f, color);
            this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 88.0f, 146.0f, FluxClientCache.getFeedbackColor());
        } else {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_WIRELESS, this.navigationTabs);
        this.inventoryButtonList.clear();
        this.buttonLists.add(this.inventoryButtonList);
        if (this.networkValid) {
            this.wirelessMode = this.network.getWirelessMode();
            this.switches.add(new SlidedSwitchButton(140, 156, 4, this.field_147003_i, this.field_147009_r, WirelessType.ENABLE_WIRELESS.isActivated(this.wirelessMode)));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.ARMOR, this, 24, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.CURIOS, this, 100, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.INVENTORY, this, 32, 56, 0, 0, 112, 40));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.HOT_BAR, this, 32, 104, 112, 0, 112, 16));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.MAIN_HAND, this, 136, 128, 52, 80, 16, 16));
            this.inventoryButtonList.add(new InventoryButton(WirelessType.OFF_HAND, this, 24, 128, 52, 80, 16, 16));
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 73, 130, 32, 12, 0).setUnclickable();
            this.field_230710_m_.add(this.apply);
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof InventoryButton) {
            this.switchSetting(((InventoryButton)button).type);
        }
        if (button instanceof NormalButton && button.id == 0) {
            NetworkHandler.C2S_EditWireless(this.network.getNetworkID(), this.wirelessMode);
        }
        if (button instanceof SlidedSwitchButton) {
            ((SlidedSwitchButton)button).switchButton();
            if (button.id == 4) {
                this.switchSetting(WirelessType.ENABLE_WIRELESS);
            }
        }
    }

    public void switchSetting(WirelessType type) {
        if (type != WirelessType.INVENTORY) {
            this.wirelessMode ^= 1 << type.ordinal();
            this.apply.clickable = true;
        }
    }

    @Override
    public void onFeedbackAction(@Nonnull FeedbackInfo info) {
        super.onFeedbackAction(info);
        if (this.apply != null && info == FeedbackInfo.SUCCESS) {
            this.apply.clickable = false;
        }
    }
}

