/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.register.NetworkHandler;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public InvisibleButton redirectButton;
    public NormalButton apply;
    public NormalButton delete;
    public int deleteCount;

    public GuiTabSettings(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        if (this.networkValid) {
            this.securityType = this.network.getSecurity().getType();
        }
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.networkValid) {
            if (mouseX > 30 + this.field_147003_i && mouseX < 66 + this.field_147003_i && mouseY > 140 + this.field_147009_r && mouseY < 152 + this.field_147009_r) {
                if (this.delete.clickable) {
                    this.drawCenterText(matrixStack, TextFormatting.BOLD + FluxTranslate.DELETE_NETWORK.t(), 48.0f, 128.0f, 0xFF0000);
                } else {
                    this.drawCenterText(matrixStack, FluxTranslate.DOUBLE_SHIFT.t(), 48.0f, 128.0f, 0xFFFFFF);
                }
            }
            this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 88.0f, 156.0f, FluxClientCache.getFeedbackColor());
        } else {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.networkValid) {
            this.nameField.func_146180_a(this.network.getNetworkName());
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 112, 140, 36, 12, 3).setUnclickable();
            this.field_230710_m_.add(this.apply);
            this.delete = new NormalButton(FluxTranslate.DELETE.t(), 30, 140, 36, 12, 4).setUnclickable();
            this.field_230710_m_.add(this.delete);
            int i = 0;
            boolean colorSet = false;
            for (EnumNetworkColor color : EnumNetworkColor.values()) {
                ColorButton b2 = new ColorButton(48 + (i >= 7 ? i - 7 : i) * 16, 91 + (i >= 7 ? 1 : 0) * 16, color.getRGB());
                this.colorButtons.add(b2);
                if (!colorSet && color.getRGB() == this.network.getNetworkColor()) {
                    this.colorBtn = b2;
                    this.colorBtn.selected = true;
                    colorSet = true;
                }
                ++i;
            }
            if (!colorSet) {
                ColorButton c = new ColorButton(32, 107, this.network.getNetworkColor());
                this.colorButtons.add(c);
                this.colorBtn = c;
                this.colorBtn.selected = true;
            }
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.networkValid && this.apply != null) {
            this.apply.clickable = (this.securityType != SecurityType.ENCRYPTED || this.passwordField.func_146179_b().length() != 0) && this.nameField.func_146179_b().length() != 0;
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (this.networkValid && button instanceof NormalButton) {
            switch (button.id) {
                case 3: {
                    NetworkHandler.C2S_EditNetwork(this.network.getNetworkID(), this.nameField.func_146179_b(), this.colorBtn.color, this.securityType, this.passwordField.func_146179_b());
                    break;
                }
                case 4: {
                    NetworkHandler.C2S_DeleteNetwork(this.network.getNetworkID());
                }
            }
        }
    }

    @Override
    public boolean keyPressedMain(int keyCode, int scanCode, int modifiers) {
        if (this.delete != null) {
            if (keyCode == 340) {
                ++this.deleteCount;
                if (this.deleteCount > 1) {
                    this.delete.clickable = true;
                }
            } else {
                this.deleteCount = 0;
                this.delete.clickable = false;
            }
        }
        return super.keyPressedMain(keyCode, scanCode, modifiers);
    }

    @Override
    public void onFeedbackAction(@Nonnull FeedbackInfo info) {
        super.onFeedbackAction(info);
        if (info == FeedbackInfo.SUCCESS) {
            this.switchTab(EnumNavigationTab.TAB_HOME);
        } else if (info == FeedbackInfo.SUCCESS_2) {
            this.apply.clickable = false;
        }
    }
}

