/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;

public class PageLabelButton
extends GuiButtonCore {
    public int page;
    public int pages;
    public int color;
    public double currentLeft;
    public double singleWidth;
    public int hoveredPage;
    public int showTick;

    public PageLabelButton(int x, int y, int page, int pages, int color) {
        super(x, y, 148, 4, 0);
        this.color = color;
        this.refreshPages(page, pages);
    }

    @Override
    public void drawButton(Minecraft mc, MatrixStack matrixStack, int mouseX, int mouseY, int guiLeft, int guiTop) {
        GlStateManager.func_227626_N_();
        PageLabelButton.drawRect(this.x, this.y, this.x + this.width, this.y + 1, -2130706433);
        PageLabelButton.drawRect(this.x, this.y + 3, this.x + this.width, this.y + this.height, -2130706433);
        PageLabelButton.drawRect(this.currentLeft, this.y + 1, this.currentLeft + this.singleWidth, this.y + 3, this.color | 0xF0000000);
        boolean b = this.isMouseHovered(mc, mouseX - guiLeft, mouseY - guiTop);
        if (b) {
            this.hoveredPage = (int)((double)(mouseX - guiLeft - this.x - 1) / this.singleWidth) + 1;
            if (this.hoveredPage != this.page) {
                double c = (double)(this.hoveredPage - 1) * this.singleWidth + (double)this.x + 1.0;
                PageLabelButton.drawRect(c, this.y + 1, c + this.singleWidth, this.y + 3, this.color | 0x60000000);
            }
            PageLabelButton.drawCenterText(matrixStack, mc.field_71466_p, this.hoveredPage + " / " + this.pages, 88.0f, this.y + 6, this.color);
        } else if (this.showTick > 0) {
            int alpha = Math.min(255, this.showTick * 32);
            GlStateManager.func_227709_e_();
            GlStateManager.func_227740_m_();
            PageLabelButton.drawCenterText(matrixStack, mc.field_71466_p, this.page + " / " + this.pages, 88.0f, this.y + 6, this.color | alpha << 24);
            GlStateManager.func_227737_l_();
            --this.showTick;
        }
        PageLabelButton.drawRect(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + 3, 0x20000000);
        GlStateManager.func_227627_O_();
    }

    @Override
    public boolean isMouseHovered(Minecraft mc, int mouseX, int mouseY) {
        return mouseX >= this.x + 1 && mouseY >= this.y && mouseX < this.x + this.width - 1 && mouseY < this.y + this.height;
    }

    public void refreshPages(int page, int pages) {
        this.page = page;
        this.pages = pages;
        this.singleWidth = 146.0 / (double)pages;
        this.currentLeft = (double)(page - 1) * this.singleWidth + (double)this.x + 1.0;
        this.showTick = 40;
    }

    public static void drawCenterText(MatrixStack matrixStack, FontRenderer fontRendererIn, String text, float x, float y, int color) {
        fontRendererIn.func_238421_b_(matrixStack, text, x - (float)fontRendererIn.func_78256_a(text) / 2.0f, y, color);
    }
}

