/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;

public class IMCHandler {
    public static void handleIMCMessage(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String sender = message.getSenderModId();
            Object obj = message.getMessageSupplier().get();
            switch (message.getMethod()) {
                case "RegisterMarketCategory": {
                    if (obj instanceof CompoundNBT) {
                        CompoundNBT tagCompound = (CompoundNBT)obj;
                        ResourceLocation registryName = new ResourceLocation(tagCompound.func_74779_i("RegistryName"));
                        if (registryName.func_110624_b().equals(sender)) {
                            String tooltipLangKey = tagCompound.func_150297_b("Tooltip", 8) ? tagCompound.func_74779_i("Tooltip") : "gui.farmingforblockheads:market.tooltip_none";
                            ItemStack icon = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Icon"));
                            int sortIndex = tagCompound.func_74762_e("SortIndex");
                            FarmingForBlockheadsAPI.registerMarketCategory(registryName, tooltipLangKey, icon, sortIndex);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category must be prefixed by your mod id (from {})", (Object)sender);
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                    break;
                }
                case "RegisterMarketEntry": {
                    if (obj instanceof CompoundNBT) {
                        CompoundNBT tagCompound = (CompoundNBT)obj;
                        if (!tagCompound.func_150297_b("OutputItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires OutputItem tag (from {})", (Object)sender);
                            break;
                        }
                        if (!tagCompound.func_150297_b("CostItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires CostItem tag (from {})", (Object)sender);
                            break;
                        }
                        ItemStack outputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("OutputItem"));
                        ItemStack costItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("CostItem"));
                        ResourceLocation categoryId = tagCompound.func_150297_b("Category", 8) ? new ResourceLocation(tagCompound.func_74779_i("Category")) : FarmingForBlockheadsAPI.MARKET_CATEGORY_OTHER;
                        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(categoryId);
                        if (category != null) {
                            FarmingForBlockheadsAPI.registerMarketEntry(outputItem, costItem, category);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category {} does not exist (from {})", (Object)categoryId, (Object)sender);
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                }
            }
        });
    }
}

