/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.network.ChickenNestEffectMessage;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.farmingforblockheads.tile.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChickenNestTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int TICK_INTERVAL = 20;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != Items.field_151110_aK) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 4;
        }

        protected void onContentsChanged(int slot) {
            ChickenNestTileEntity.this.isDirty = true;
            ChickenNestTileEntity.this.func_70296_d();
        }
    };
    private int tickTimer;
    private boolean isDirty;

    public ChickenNestTileEntity() {
        super(ModTileEntities.chickenNest);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickTimer;
            if (this.tickTimer >= 20) {
                this.stealEgg();
                this.tickTimer = 0;
            }
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tagCompound = new CompoundNBT();
        this.func_189515_b(tagCompound);
        return tagCompound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    private void stealEgg() {
        float range = ((Integer)FarmingForBlockheadsConfig.COMMON.chickenNestRange.get()).intValue();
        AxisAlignedBB aabb = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range), (double)((float)this.field_174879_c.func_177956_o() + range), (double)((float)this.field_174879_c.func_177952_p() + range));
        List list = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, p -> p != null && p.func_92059_d().func_77973_b() == Items.field_151110_aK && p.func_92059_d().func_190916_E() == 1 && p.func_200214_m() == null);
        if (list.isEmpty()) {
            return;
        }
        ItemEntity entityItem = (ItemEntity)list.get(0);
        ItemStack restStack = entityItem.func_92059_d().func_77946_l();
        for (int i = 0; i < this.itemHandler.getSlots() && !(restStack = this.itemHandler.insertItem(i, restStack, false)).func_190926_b(); ++i) {
        }
        if (restStack.func_190926_b()) {
            entityItem.func_70106_y();
            NetworkHandler.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new ChickenNestEffectMessage(this.field_174879_c));
        } else {
            entityItem.func_92058_a(restStack);
        }
        this.func_70296_d();
    }

    public int getEggCount() {
        return this.itemHandler.getStackInSlot(0).func_190916_E();
    }
}

