/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageWrapperStorageDisk;
import edivad.extrastorage.items.fluid.FluidStorageType;
import edivad.extrastorage.tiles.AdvancedFluidStorageBlockTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedFluidStorageNetworkNode
extends FluidStorageNetworkNode {
    public static final ResourceLocation BLOCK_FLUID_16384K_ID = new ResourceLocation("extrastorage", "block_16384k_fluid");
    public static final ResourceLocation BLOCK_FLUID_65536K_ID = new ResourceLocation("extrastorage", "block_65536k_fluid");
    public static final ResourceLocation BLOCK_FLUID_262144K_ID = new ResourceLocation("extrastorage", "block_262144k_fluid");
    public static final ResourceLocation BLOCK_FLUID_1048576K_ID = new ResourceLocation("extrastorage", "block_1048576k_fluid");
    private final FluidStorageType type;
    private IStorageDisk<FluidStack> storage;

    public AdvancedFluidStorageNetworkNode(World world, BlockPos pos, FluidStorageType type) {
        super(world, pos, null);
        this.type = type;
    }

    public int getEnergyUsage() {
        return 10 + this.type.ordinal() * 2;
    }

    public ResourceLocation getId() {
        switch (this.type) {
            case TIER_5: {
                return BLOCK_FLUID_16384K_ID;
            }
            case TIER_6: {
                return BLOCK_FLUID_65536K_ID;
            }
            case TIER_7: {
                return BLOCK_FLUID_262144K_ID;
            }
            case TIER_8: {
                return BLOCK_FLUID_1048576K_ID;
            }
        }
        return null;
    }

    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<FluidStack>)this.storage);
    }

    public void loadStorage(@Nullable PlayerEntity owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerWorld)this.world).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk((ServerWorld)this.world, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerWorld)this.world).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerWorld)this.world).markForSaving();
        }
        this.storage = new FluidStorageWrapperStorageDisk((FluidStorageNetworkNode)this, disk);
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("block.extrastorage.block_" + this.type.getName() + "_fluid");
    }

    public long getStored() {
        return (Long)AdvancedFluidStorageBlockTile.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

