/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<Structure<?>> allowedStructures;
    private Map<Structure<?>, List<ResourceLocation>> dimensionsForAllowedStructures;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<Structure<?>> allowedStructures, Map<Structure<?>, List<ResourceLocation>> dimensionsForAllowedStructures) {
        this.canTeleport = canTeleport;
        this.allowedStructures = allowedStructures;
        this.dimensionsForAllowedStructures = dimensionsForAllowedStructures;
    }

    public SyncPacket(PacketBuffer buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedStructures = new ArrayList();
        this.dimensionsForAllowedStructures = new HashMap();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            Structure<?> structure = StructureUtils.getStructureForKey(buf.func_192575_l());
            this.allowedStructures.add(structure);
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.func_192575_l());
            }
            this.dimensionsForAllowedStructures.put(structure, dimensions);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructures.size());
        for (Structure<?> structure : this.allowedStructures) {
            buf.func_192572_a(StructureUtils.getKeyForStructure(structure));
            List<ResourceLocation> dimensions = this.dimensionsForAllowedStructures.get(structure);
            buf.writeInt(dimensions.size());
            for (ResourceLocation dimensionKey : dimensions) {
                buf.func_192572_a(dimensionKey);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ExplorersCompass.canTeleport = this.canTeleport;
            ExplorersCompass.allowedStructures = this.allowedStructures;
            ExplorersCompass.dimensionsForAllowedStructures = this.dimensionsForAllowedStructures;
        });
        ctx.get().setPacketHandled(true);
    }
}

