/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, World level) {
        super(entityType, level);
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/Tag;)D"))
    private double setFluidHeight(LivingEntity entity, ITag<Fluid> tag) {
        if (entity instanceof PlayerEntity) {
            ActionResultType shouldSwim = EventDispatcher.onPlayerSwim((PlayerEntity)entity);
            return Util.processEventResult(shouldSwim, 1.0, 0.0, () -> entity.func_233571_b_(tag));
        }
        return entity.func_233571_b_(tag);
    }

    @Redirect(method={"aiStep", "travel", "checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z"))
    private boolean setInWater(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return Util.processEventResult(EventDispatcher.onPlayerSwim((PlayerEntity)entity), () -> ((LivingEntity)entity).func_70090_H());
        }
        return entity.func_70090_H();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    private void resetFallHeight(CallbackInfo info) {
        if (this instanceof PlayerEntity && EventDispatcher.onPlayerSwim((PlayerEntity)this).func_226246_a_()) {
            this.field_70143_R = 0.0f;
        }
    }

    @Redirect(method={"travel"}, allow=2, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFree(DDD)Z"))
    private boolean cancelLeaveFluidAssist(LivingEntity entity, double d, double e, double f) {
        if (entity instanceof PlayerEntity && EventDispatcher.onPlayerSwim((PlayerEntity)entity).func_226246_a_()) {
            return false;
        }
        return entity.func_70038_c(d, e, f);
    }
}

