/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.forge;

import be.florens.expandability.api.forge.LivingFluidCollisionEvent;
import be.florens.expandability.api.forge.PlayerSwimEvent;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EventDispatcherImpl {
    public static ActionResultType onPlayerSwim(PlayerEntity player) {
        PlayerSwimEvent event = new PlayerSwimEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return EventDispatcherImpl.getEventResult((Event)event);
    }

    public static boolean onLivingFluidCollision(LivingEntity entity, FluidState fluidState) {
        LivingFluidCollisionEvent event = new LivingFluidCollisionEvent(entity, fluidState);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() == Event.Result.ALLOW;
    }

    private static ActionResultType getEventResult(Event event) {
        switch (event.getResult()) {
            case ALLOW: {
                return ActionResultType.SUCCESS;
            }
            case DENY: {
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }
}

