/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.util;

import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModelPart;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.VanillaModelMapping;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BoneModelPart;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class AnimationUtil {
    private static final Map<Model, Map<String, ModelRenderer>> MODEL_PARTS = new HashMap<Model, Map<String, ModelRenderer>>();
    private static final Map<String, String> MAPPED_NAMES = new HashMap<String, String>();

    public static void copyAngles(String name, GeometryModel model, ModelRenderer part) {
        model.getModelPart(name).ifPresent(bonePart -> {
            if (bonePart instanceof BoneModelPart) {
                AnimationUtil.applyPose(part, (BoneModelPart)bonePart);
            }
        });
    }

    public static void applyPose(ModelRenderer part, BoneModelPart modelPart) {
        AnimatedModelPart.AnimationPose pose = modelPart.getAnimationPose();
        part.field_78795_f += (float)((double)pose.getRotation().func_195899_a() * Math.PI / 180.0);
        part.field_78796_g += (float)((double)pose.getRotation().func_195900_b() * Math.PI / 180.0);
        part.field_78808_h += (float)((double)pose.getRotation().func_195902_c() * Math.PI / 180.0);
        part.field_78800_c += pose.getPosition().func_195899_a();
        part.field_78797_d -= pose.getPosition().func_195900_b();
        part.field_78798_e += pose.getPosition().func_195902_c();
    }

    public static Map<String, ModelRenderer> mapRenderers(Model model) {
        HashMap<String, ModelRenderer> renderers = new HashMap<String, ModelRenderer>();
        for (Class<?> i = model.getClass(); i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic() || !ModelRenderer.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    renderers.put(field.getName(), (ModelRenderer)field.get(model));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return renderers;
    }

    public static Map<String, ModelRenderer> getMappings(Model model) {
        return MODEL_PARTS.computeIfAbsent(model, AnimationUtil::mapRenderers);
    }

    public static String getNameForPart(String name, Model model) {
        return MAPPED_NAMES.computeIfAbsent(name, key -> VanillaModelMapping.get(model.getClass(), (String)key));
    }
}

