/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;

public class EtchedVillagers {
    public static final PollinatedRegistry<VillagerProfession> PROFESSIONS = PollinatedRegistry.create((Registry)Registry.field_218370_L, (String)"etched");
    public static final PollinatedRegistry<PointOfInterestType> POI_TYPES = PollinatedRegistry.create((Registry)Registry.field_218371_M, (String)"etched");
    public static final Supplier<PointOfInterestType> BARD_POI = POI_TYPES.register("bard", () -> PointOfInterestType.func_221052_a((PointOfInterestType)new PointOfInterestType("etched:bard", (Set)ImmutableSet.builder().addAll((Iterable)Blocks.field_196586_al.func_176194_O().func_177619_a()).build(), 1, 1)));
    public static final Supplier<VillagerProfession> BARD = PROFESSIONS.register("bard", () -> new VillagerProfession("etched:bard", BARD_POI.get(), ImmutableSet.of(), ImmutableSet.of(), null));

    public static void registerVillages() {
        PlainsVillagePools.func_214744_a();
        DesertVillagePools.func_222739_a();
        SavannaVillagePools.func_214745_a();
        SnowyVillagePools.func_214746_a();
        TaigaVillagePools.func_214806_a();
        EtchedVillagers.createVillagePiece("plains", "bard_house", 1, 2, ProcessorLists.field_244107_g, ProcessorLists.field_244102_b);
        EtchedVillagers.createVillagePiece("desert", "bard_house", 1, 2, ProcessorLists.field_244106_f);
        EtchedVillagers.createVillagePiece("savanna", "bard_house", 1, 4, ProcessorLists.field_244103_c);
        EtchedVillagers.createVillagePiece("snowy", "bard_house", 1, 4, ProcessorLists.field_244104_d);
        EtchedVillagers.createVillagePiece("taiga", "bard_house", 1, 4, ProcessorLists.field_244107_g, ProcessorLists.field_244105_e);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, StructureProcessorList zombieProcessor) {
        EtchedVillagers.createVillagePiece(village, name, houseId, weight, ProcessorLists.field_244101_a, zombieProcessor);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, StructureProcessorList normalProcessor, StructureProcessorList zombieProcessor) {
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), normalProcessor, weight);
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/zombie/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), zombieProcessor, weight);
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation pieceId, StructureProcessorList processorList, int weight) {
        JigsawPattern pool = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(poolId);
        if (pool == null) {
            return;
        }
        JigsawPiece piece = (JigsawPiece)JigsawPiece.func_242851_a((String)pieceId.toString(), (StructureProcessorList)processorList).apply(JigsawPattern.PlacementBehaviour.RIGID);
        List<JigsawPiece> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        List<Pair<JigsawPiece, Integer>> rawTemplates = ((StructureTemplatePoolAccessor)pool).getRawTemplates();
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
        rawTemplates.add((Pair<JigsawPiece, Integer>)Pair.of((Object)piece, (Object)weight));
    }
}

