/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.core.hook.extension.VillagerExtension;
import gg.moonflower.etched.core.util.AnimationUtil;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedGeometryEntityModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerModel.class})
public class VillagerModelMixin<T extends Entity> {
    private static final AnimatedGeometryEntityModel<Entity> RIG = new AnimatedGeometryEntityModel(new ResourceLocation("etched", "villager"));
    private static final Set<String> USED_BONES = new HashSet<String>();
    private static final Map<ModelRenderer, ModelRenderer> ORIGINS = new HashMap<ModelRenderer, ModelRenderer>();
    @Shadow
    protected ModelRenderer field_78191_a;
    @Shadow
    protected ModelRenderer field_217151_b;
    @Shadow
    @Final
    protected ModelRenderer field_217152_f;
    @Shadow
    @Final
    protected ModelRenderer field_82898_f;
    @Shadow
    @Final
    protected ModelRenderer field_78189_b;
    @Shadow
    @Final
    protected ModelRenderer field_217153_h;
    @Shadow
    @Final
    protected ModelRenderer field_78190_c;
    @Shadow
    @Final
    protected ModelRenderer field_78187_d;
    @Shadow
    @Final
    protected ModelRenderer field_78188_e;

    private static ModelRenderer getOrigin(ModelRenderer part) {
        return ORIGINS.computeIfAbsent(part, ModelRenderer::func_241662_a_);
    }

    private static void reset(ModelRenderer part) {
        part.func_217177_a(VillagerModelMixin.getOrigin(part));
    }

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void reset(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension)) {
            return;
        }
        VillagerModelMixin.reset(this.field_78191_a);
        VillagerModelMixin.reset(this.field_217151_b);
        VillagerModelMixin.reset(this.field_217152_f);
        VillagerModelMixin.reset(this.field_82898_f);
        VillagerModelMixin.reset(this.field_78189_b);
        VillagerModelMixin.reset(this.field_217153_h);
        VillagerModelMixin.reset(this.field_78190_c);
        VillagerModelMixin.reset(this.field_78187_d);
        VillagerModelMixin.reset(this.field_78188_e);
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void animate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof VillagerExtension) || !((VillagerExtension)entity).isDancing()) {
            return;
        }
        USED_BONES.clear();
        RIG.setAnimations(new ResourceLocation[]{new ResourceLocation("etched", "dance")});
        for (AnimationData animation : RIG.getAnimations()) {
            for (AnimationData.BoneAnimation boneAnimation : animation.getBoneAnimations()) {
                USED_BONES.add(boneAnimation.getName());
            }
        }
        RIG.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        GeometryModel model = RIG.getModel();
        Map<String, ModelRenderer> partMappings = AnimationUtil.getMappings((Model)((VillagerModel)this));
        USED_BONES.forEach(s -> AnimationUtil.copyAngles(s, model, (ModelRenderer)partMappings.get(AnimationUtil.getNameForPart(s, (Model)((VillagerModel)this)))));
    }
}

