/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.entity.MinecartJukebox;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.ClientboundAddMinecartJukeboxPacket;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.handler.EtchedClientPlayPacketHandler;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MinecartTickableSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandlerImpl
implements EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt, PollinatedPacketContext ctx) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        BlockPos pos = pkt.getPos();
        ISound soundInstance = playingRecords.get(pos);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                soundManager.func_147683_b(soundInstance);
                playingRecords.remove(pos);
            }
            if (pkt.getTracks().length == 0) {
                return;
            }
            SoundTracker.playBlockRecord(pos, pkt.getTracks(), 0);
        });
    }

    @Override
    public void handleAddMinecartJukeboxPacket(ClientboundAddMinecartJukeboxPacket pkt, PollinatedPacketContext ctx) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            MinecartJukebox entity = new MinecartJukebox((World)level, pkt.getX(), pkt.getY(), pkt.getZ());
            int i = pkt.getId();
            entity.func_213312_b(pkt.getX(), pkt.getY(), pkt.getZ());
            entity.func_225653_b_(pkt.getX(), pkt.getY(), pkt.getZ());
            entity.field_70125_A = (float)(pkt.getxRot() * 360) / 256.0f;
            entity.field_70177_z = (float)(pkt.getyRot() * 360) / 256.0f;
            entity.func_145769_d(i);
            entity.func_184221_a(pkt.getUUID());
            level.func_217411_a(i, (Entity)entity);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MinecartTickableSound((AbstractMinecartEntity)entity));
        });
    }

    @Override
    public void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, PollinatedPacketContext ctx) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        ISound soundInstance = SoundTracker.getEntitySound(entityId);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                if (soundInstance instanceof StopListeningSound) {
                    ((StopListeningSound)soundInstance).stopListening();
                }
                if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && soundManager.func_215294_c(soundInstance)) {
                    return;
                }
                SoundTracker.setEntitySound(entityId, null);
            }
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
                return;
            }
            Entity entity = level.func_73045_a(entityId);
            if (entity == null) {
                LOGGER.error("Server sent sound for nonexistent entity: " + entityId);
                return;
            }
            ItemStack record = pkt.getRecord();
            if (!PlayableRecord.isPlayableRecord(record)) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            Optional<? extends ISound> sound = ((PlayableRecord)record.func_77973_b()).createEntitySound(record, entity, 0);
            if (!sound.isPresent()) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> Minecraft.func_71410_x().func_212871_a_(() -> {
                SoundTracker.setEntitySound(entityId, null);
                SoundTracker.playEntityRecord(record, entityId, 1, false);
            }));
            SoundTracker.setEntitySound(entityId, entitySound);
        });
    }

    @Override
    public void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof EtchingScreen) {
                EtchingScreen screen = (EtchingScreen)Minecraft.func_71410_x().field_71462_r;
                screen.setReason(pkt.getException());
            }
        });
    }

    @Override
    public void handleSetUrl(ClientboundSetUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof RadioScreen) {
                RadioScreen screen = (RadioScreen)Minecraft.func_71410_x().field_71462_r;
                screen.receiveUrl(pkt.getUrl());
            }
        });
    }

    @Override
    public void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, PollinatedPacketContext ctx) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ctx.enqueueWork(() -> {
            if (minecraft.field_71441_e != null && minecraft.field_71462_r instanceof AlbumJukeboxScreen) {
                AlbumJukeboxScreen screen = (AlbumJukeboxScreen)minecraft.field_71462_r;
                BlockPos pos = ((AlbumJukeboxMenu)screen.func_212873_a_()).getPos();
                if (((AlbumJukeboxMenu)screen.func_212873_a_()).setPlayingTrack((World)minecraft.field_71441_e, pkt)) {
                    AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(minecraft.field_71441_e.func_175625_s(pos));
                    SoundTracker.playAlbum(entity, entity.func_195044_w(), minecraft.field_71441_e, pos, true);
                }
            }
        });
    }
}

