/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.BoomboxMenu;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends Item
implements ContainerItem {
    private static final Map<Integer, ItemStack> PLAYING_RECORDS = new Int2ObjectArrayMap();
    private static final ITextComponent PAUSE = new TranslationTextComponent("item.etched.boombox.pause", new Object[]{new KeybindTextComponent("key.sneak"), new KeybindTextComponent("key.use")}).func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent RECORDS = new TranslationTextComponent("item.etched.boombox.records");
    public static final ITextComponent PAUSED = new TranslationTextComponent("item.etched.boombox.paused").func_240699_a_(TextFormatting.YELLOW);

    public BoomboxItem(Item.Properties properties) {
        super(properties);
    }

    private static void updatePlaying(Entity entity, ItemStack record) {
        if (!ItemStack.func_77989_b((ItemStack)PLAYING_RECORDS.getOrDefault(entity.func_145782_y(), ItemStack.field_190927_a), (ItemStack)record)) {
            SoundTracker.playBoombox(entity.func_145782_y(), record);
            if (record.func_190926_b()) {
                PLAYING_RECORDS.remove(entity.func_145782_y());
            } else {
                PLAYING_RECORDS.put(entity.func_145782_y(), record);
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.field_70170_p.func_201670_d()) {
            return false;
        }
        BoomboxItem.updatePlaying((Entity)entity, BoomboxItem.hasRecord(stack) && !BoomboxItem.isPaused(stack) ? BoomboxItem.getRecord(stack) : ItemStack.field_190927_a);
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_226563_dT_()) {
            BoomboxItem.setPaused(stack, !BoomboxItem.isPaused(stack));
            return ActionResult.func_233538_a_((Object)stack, (boolean)level.func_201670_d());
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public Container constructMenu(int containerId, PlayerInventory inventory, PlayerEntity player, int index) {
        return new BoomboxMenu(containerId, inventory, index);
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltipComponents, ITooltipFlag isAdvanced) {
        tooltipComponents.add(PAUSE);
        if (BoomboxItem.hasRecord(stack)) {
            ItemStack record = BoomboxItem.getRecord(stack);
            LinkedList records = new LinkedList();
            record.func_77973_b().func_77624_a(record, level, records, isAdvanced);
            if (!records.isEmpty()) {
                tooltipComponents.add(StringTextComponent.field_240750_d_);
                tooltipComponents.add(RECORDS);
                tooltipComponents.addAll(records);
            }
        }
    }

    @Nullable
    public static Hand getPlayingHand(LivingEntity entity) {
        if (!PLAYING_RECORDS.containsKey(entity.func_145782_y())) {
            return null;
        }
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return Hand.MAIN_HAND;
        }
        stack = entity.func_184592_cb();
        if (stack.func_77973_b() instanceof BoomboxItem && BoomboxItem.hasRecord(stack)) {
            return Hand.OFF_HAND;
        }
        return null;
    }

    public static boolean isPaused(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BoomboxItem)) {
            return false;
        }
        CompoundNBT compoundTag = stack.func_77978_p();
        return compoundTag != null && compoundTag.func_74767_n("Paused");
    }

    public static boolean hasRecord(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BoomboxItem)) {
            return false;
        }
        CompoundNBT compoundTag = stack.func_77978_p();
        return compoundTag != null && compoundTag.func_150297_b("Record", 10);
    }

    public static ItemStack getRecord(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BoomboxItem)) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT compoundTag = stack.func_77978_p();
        return compoundTag != null && compoundTag.func_150297_b("Record", 10) ? ItemStack.func_199557_a((CompoundNBT)compoundTag.func_74775_l("Record")) : ItemStack.field_190927_a;
    }

    public static void setRecord(ItemStack stack, ItemStack record) {
        if (!(stack.func_77973_b() instanceof BoomboxItem)) {
            return;
        }
        if (record.func_190926_b()) {
            stack.func_196083_e("Record");
        } else {
            stack.func_196082_o().func_218657_a("Record", (INBT)record.func_77955_b(new CompoundNBT()));
        }
    }

    public static void setPaused(ItemStack stack, boolean paused) {
        if (!(stack.func_77973_b() instanceof BoomboxItem)) {
            return;
        }
        if (!paused) {
            stack.func_196083_e("Paused");
        } else {
            stack.func_196082_o().func_74757_a("Paused", true);
        }
    }

    static {
        TickEvents.LIVING_PRE.register(entity -> {
            if (!entity.field_70170_p.func_201670_d()) {
                return true;
            }
            ItemStack newPlayingRecord = ItemStack.field_190927_a;
            ItemStack mainStack = entity.func_184614_ca();
            ItemStack offStack = entity.func_184592_cb();
            if (mainStack.func_77973_b() instanceof BoomboxItem && BoomboxItem.hasRecord(mainStack) && !BoomboxItem.isPaused(mainStack)) {
                newPlayingRecord = BoomboxItem.getRecord(mainStack);
            } else if (offStack.func_77973_b() instanceof BoomboxItem && BoomboxItem.hasRecord(offStack) && !BoomboxItem.isPaused(offStack)) {
                newPlayingRecord = BoomboxItem.getRecord(offStack);
            }
            if (entity instanceof PlayerEntity && newPlayingRecord.func_190926_b() && Minecraft.func_71410_x().field_175622_Z == entity) {
                PlayerInventory inventory = ((PlayerEntity)entity).field_71071_by;
                for (ItemStack stack : inventory.field_70462_a) {
                    if (!(stack.func_77973_b() instanceof BoomboxItem) || !BoomboxItem.hasRecord(stack) || BoomboxItem.isPaused(stack)) continue;
                    newPlayingRecord = BoomboxItem.getRecord(stack);
                }
            }
            BoomboxItem.updatePlaying((Entity)entity, newPlayingRecord);
            return true;
        });
    }
}

