/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.AbstractOnlineSoundInstance;
import gg.moonflower.etched.api.sound.OnlineRecordSoundInstance;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.block.RadioBlock;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.core.mixin.client.GuiAccessor;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.etched.core.registry.EtchedTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SoundTracker {
    private static final Int2ObjectArrayMap<ISound> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();
    private static final ITextComponent RADIO = new TranslationTextComponent("sound_source.etched.radio");

    private static synchronized void setRecordPlayingNearby(World level, BlockPos pos, boolean playing) {
        BlockState state = level.func_180495_p(pos);
        if (state.func_235714_a_(EtchedTags.AUDIO_PROVIDER) || state.func_203425_a(Blocks.field_150421_aI)) {
            for (LivingEntity livingEntity : level.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
                livingEntity.func_191987_a(pos, playing);
            }
        }
    }

    @Nullable
    public static ISound getEntitySound(int entity) {
        return (ISound)ENTITY_PLAYING_SOUNDS.get(entity);
    }

    public static void setEntitySound(int entity, @Nullable ISound instance) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        if (instance == null) {
            ISound old = (ISound)ENTITY_PLAYING_SOUNDS.remove(entity);
            if (old != null) {
                if (old instanceof StopListeningSound) {
                    ((StopListeningSound)old).stopListening();
                }
                soundManager.func_147683_b(old);
            }
        } else {
            ENTITY_PLAYING_SOUNDS.put(entity, (Object)instance);
            soundManager.func_147682_a(instance);
        }
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, final ITextComponent title, final Entity entity, int attenuationDistance, boolean stream) {
        return new OnlineRecordSoundInstance(url, entity, attenuationDistance, new MusicDownloadListener(title, () -> ((Entity)entity).func_226277_ct_(), () -> ((Entity)entity).func_226278_cu_(), () -> ((Entity)entity).func_226281_cx_()){

            @Override
            public void onSuccess() {
                if (!entity.func_70089_S() || !ENTITY_PLAYING_SOUNDS.containsKey(entity.func_145782_y())) {
                    this.clearComponent();
                } else if (PlayableRecord.canShowMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())) {
                    PlayableRecord.showMessage(title);
                }
            }

            @Override
            public void onFail() {
                PlayableRecord.showMessage((ITextComponent)new TranslationTextComponent("record.etched.downloadFail", new Object[]{title}));
            }
        }, stream ? AudioSource.AudioFileType.STREAM : AudioSource.AudioFileType.FILE);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, ITextComponent title, Entity entity, boolean stream) {
        return SoundTracker.getEtchedRecord(url, title, entity, 16, stream);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, final ITextComponent title, final ClientWorld level, final BlockPos pos, int attenuationDistance, AudioSource.AudioFileType type) {
        BlockState aboveState = level.func_180495_p(pos.func_177984_a());
        boolean muffled = aboveState.func_235714_a_((ITag)BlockTags.field_199897_a);
        final boolean hidden = !aboveState.func_196958_f();
        final Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        return new OnlineRecordSoundInstance(url, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, muffled ? 2.0f : 4.0f, muffled ? attenuationDistance / 2 : attenuationDistance, new MusicDownloadListener(title, () -> (double)pos.func_177958_n() + 0.5, () -> (double)pos.func_177956_o() + 0.5, () -> (double)pos.func_177952_p() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (!hidden && PlayableRecord.canShowMessage((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)) {
                        PlayableRecord.showMessage(title);
                    }
                    SoundTracker.setRecordPlayingNearby((World)level, pos, true);
                }
            }

            @Override
            public void onFail() {
                PlayableRecord.showMessage((ITextComponent)new TranslationTextComponent("record.etched.downloadFail", new Object[]{title}));
            }
        }, type);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, ITextComponent title, ClientWorld level, BlockPos pos, AudioSource.AudioFileType type) {
        return SoundTracker.getEtchedRecord(url, title, level, pos, 16, type);
    }

    private static void playRecord(BlockPos pos, ISound sound) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        playingRecords.put(pos, sound);
        soundManager.func_147682_a(sound);
    }

    private static void playNextRecord(ClientWorld level, BlockPos pos) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        SoundTracker.playAlbum((AlbumJukeboxBlockEntity)blockEntity, blockEntity.func_195044_w(), level, pos, true);
    }

    public static void playBlockRecord(BlockPos pos, TrackData[] tracks, int track) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        if (track >= tracks.length) {
            SoundTracker.setRecordPlayingNearby((World)level, pos, false);
            return;
        }
        TrackData trackData = tracks[track];
        if (trackData.getUrl() == null || !TrackData.isValidURL(trackData.getUrl())) {
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
            return;
        }
        SoundTracker.playRecord(pos, StopListeningSound.create((ISound)SoundTracker.getEtchedRecord(trackData.getUrl(), trackData.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.func_71410_x().func_212871_a_(() -> {
            if (!((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords().containsKey(pos)) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
        })));
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, int attenuationDistance, boolean loop) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        Entity entity = level.func_73045_a(entityId);
        if (entity == null) {
            return;
        }
        Optional<? extends ISound> sound = ((PlayableRecord)record.func_77973_b()).createEntitySound(record, entity, track, attenuationDistance);
        if (!sound.isPresent()) {
            if (loop && track != 0) {
                SoundTracker.playEntityRecord(record, entityId, 0, attenuationDistance, true);
            }
            return;
        }
        ISound entitySound = (ISound)ENTITY_PLAYING_SOUNDS.remove(entity.func_145782_y());
        if (entitySound != null) {
            if (entitySound instanceof StopListeningSound) {
                ((StopListeningSound)entitySound).stopListening();
            }
            Minecraft.func_71410_x().func_147118_V().func_147683_b(entitySound);
        }
        entitySound = StopListeningSound.create(sound.get(), () -> Minecraft.func_71410_x().func_212871_a_(() -> {
            ENTITY_PLAYING_SOUNDS.remove(entityId);
            SoundTracker.playEntityRecord(record, entityId, track + 1, attenuationDistance, loop);
        }));
        ENTITY_PLAYING_SOUNDS.put(entityId, (Object)entitySound);
        Minecraft.func_71410_x().func_147118_V().func_147682_a(entitySound);
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, boolean loop) {
        SoundTracker.playEntityRecord(record, entityId, track, 16, loop);
    }

    public static void playBoombox(int entityId, ItemStack record) {
        SoundTracker.setEntitySound(entityId, null);
        if (!record.func_190926_b()) {
            SoundTracker.playEntityRecord(record, entityId, 0, 8, true);
        }
    }

    public static void playRadio(@Nullable String url, BlockState state, ClientWorld level, BlockPos pos) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        ISound soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.func_147683_b(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((World)level, pos, false);
        }
        if (!state.func_235901_b_((Property)RadioBlock.POWERED) || ((Boolean)state.func_177229_b((Property)RadioBlock.POWERED)).booleanValue()) {
            return;
        }
        if (TrackData.isValidURL(url)) {
            SoundTracker.playRecord(pos, StopListeningSound.create((ISound)SoundTracker.getEtchedRecord(url, RADIO, level, pos, 8, AudioSource.AudioFileType.BOTH), () -> Minecraft.func_71410_x().func_212871_a_(() -> SoundTracker.playRadio(url, level.func_180495_p(pos), level, pos))));
        }
    }

    @Deprecated
    public static void playRadio(@Nullable String url, ClientWorld level, BlockPos pos) {
        SoundTracker.playRadio(url, level.func_180495_p(pos), level, pos);
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, BlockState state, ClientWorld level, BlockPos pos, boolean force) {
        Optional<TrackData[]> optional;
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        if (!state.func_235901_b_((Property)AlbumJukeboxBlock.POWERED) || !((Boolean)state.func_177229_b((Property)AlbumJukeboxBlock.POWERED)).booleanValue() && !force && !jukebox.recalculatePlayingIndex(false)) {
            return;
        }
        ISound soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.func_147683_b(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((World)level, pos, false);
        }
        if (((Boolean)state.func_177229_b((Property)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        ItemStack disc = jukebox.func_70301_a(jukebox.getPlayingIndex());
        StopListeningSound sound = null;
        if (disc.func_77973_b() instanceof MusicDiscItem) {
            sound = StopListeningSound.create((ISound)SoundTracker.getEtchedRecord(((MusicDiscItem)disc.func_77973_b()).func_185075_h().func_187503_a().toString(), (ITextComponent)((MusicDiscItem)disc.func_77973_b()).func_234801_g_(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.func_71410_x().func_212871_a_(() -> SoundTracker.playNextRecord(level, pos)));
        } else if (disc.func_77973_b() instanceof PlayableRecord && (optional = PlayableRecord.getStackMusic(disc)).isPresent()) {
            TrackData track;
            TrackData[] tracks = optional.get();
            TrackData trackData = track = jukebox.getTrack() < 0 || jukebox.getTrack() >= tracks.length ? tracks[0] : tracks[jukebox.getTrack()];
            if (TrackData.isValidURL(track.getUrl())) {
                sound = StopListeningSound.create((ISound)SoundTracker.getEtchedRecord(track.getUrl(), track.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.func_71410_x().func_212871_a_(() -> SoundTracker.playNextRecord(level, pos)));
            }
        }
        if (sound == null) {
            return;
        }
        SoundTracker.playRecord(pos, sound);
        SoundTracker.setRecordPlayingNearby((World)level, pos, true);
    }

    @Deprecated
    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, ClientWorld level, BlockPos pos, boolean force) {
        SoundTracker.playAlbum(jukebox, jukebox.func_195044_w(), level, pos, force);
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final ITextComponent title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private final BlockPos.Mutable pos;
        private float size;
        private ITextComponent requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(ITextComponent title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
            this.pos = new BlockPos.Mutable();
        }

        private BlockPos.Mutable getPos() {
            return this.pos.func_189532_c(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble());
        }

        private void setComponent(ITextComponent text) {
            if (!(this.component != null || Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_180495_p((BlockPos)this.getPos().func_189536_c(Direction.UP)).func_196958_f() && PlayableRecord.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble()))) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)this.component, true);
                ((GuiAccessor)Minecraft.func_71410_x().field_71456_v).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (((GuiAccessor)Minecraft.func_71410_x().field_71456_v).getOverlayMessageString() == this.component) {
                ((GuiAccessor)Minecraft.func_71410_x().field_71456_v).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(ITextComponent component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((ITextComponent)this.requesting.func_230532_e_().func_240702_b_(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((ITextComponent)new TranslationTextComponent("record.etched.downloadProgress", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((ITextComponent)new TranslationTextComponent("record.etched.loading", new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("record.etched.downloadFail", new Object[]{this.title}), true);
        }
    }

    private static class DownloadTextComponent
    extends TextComponent {
        private String text = "";
        private IReorderingProcessor visualOrderText;
        private LanguageMap decomposedWith;

        public String func_150261_e() {
            return this.text;
        }

        public StringTextComponent plainCopy() {
            return new StringTextComponent(this.text);
        }

        @OnlyIn(value=Dist.CLIENT)
        public IReorderingProcessor func_241878_f() {
            LanguageMap language = LanguageMap.func_74808_a();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.func_241870_a((ITextProperties)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public String toString() {
            return "TextComponent{text='" + this.text + '\'' + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
        }

        public void setText(String text) {
            this.text = text;
            this.decomposedWith = null;
        }
    }
}

