/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedSounds;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtchingMenu
extends Container {
    public static final ResourceLocation EMPTY_SLOT_MUSIC_DISC = new ResourceLocation("etched", "item/empty_etching_table_slot_music_disc");
    public static final ResourceLocation EMPTY_SLOT_MUSIC_LABEL = new ResourceLocation("etched", "item/empty_etching_table_slot_music_label");
    private static final Cache<String, CompletableFuture<TrackData[]>> DATA_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final boolean IGNORE_CACHE = false;
    private static final Set<String> VALID_FORMATS;
    private final IWorldPosCallable access;
    private final IntReferenceHolder labelIndex;
    private final Slot discSlot;
    private final Slot labelSlot;
    private final Slot resultSlot;
    private final IInventory input;
    private final IInventory result;
    private final PlayerEntity player;
    private String url;
    private int urlId;
    private long lastSoundTime;
    private CompletableFuture<?> currentRequest;
    private int currentRequestId;

    public EtchingMenu(int id, PlayerInventory inventory) {
        this(id, inventory, IWorldPosCallable.field_221489_a);
    }

    public EtchingMenu(int id, PlayerInventory inventory, final IWorldPosCallable containerLevelAccess) {
        super(EtchedMenus.ETCHING_MENU.get(), id);
        this.player = inventory.field_70458_d;
        this.labelIndex = IntReferenceHolder.func_221492_a();
        this.input = new Inventory(2){

            public void func_70296_d() {
                super.func_70296_d();
                EtchingMenu.this.func_75130_a((IInventory)this);
            }
        };
        this.result = new Inventory(1){

            public void func_70296_d() {
                super.func_70296_d();
            }
        };
        this.access = containerLevelAccess;
        this.discSlot = this.func_75146_a(new Slot(this.input, 0, 44, 43){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == EtchedItems.BLANK_MUSIC_DISC.get() || stack.func_77973_b() == EtchedItems.ETCHED_MUSIC_DISC.get();
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_SLOT_MUSIC_DISC);
            }
        });
        this.labelSlot = this.func_75146_a(new Slot(this.input, 1, 62, 43){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof SimpleMusicLabelItem;
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_SLOT_MUSIC_LABEL);
            }
        });
        this.resultSlot = this.func_75146_a(new Slot(this.result, 0, 116, 43){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                EtchingMenu.this.discSlot.func_75209_a(1);
                EtchingMenu.this.labelSlot.func_75209_a(1);
                if (!EtchingMenu.this.discSlot.func_75216_d() || !EtchingMenu.this.labelSlot.func_75216_d()) {
                    EtchingMenu.this.labelIndex.func_221494_a(0);
                }
                EtchingMenu.this.setupResultSlot();
                EtchingMenu.this.func_75142_b();
                containerLevelAccess.func_221486_a((level, pos) -> {
                    long l = level.func_82737_E();
                    if (EtchingMenu.this.lastSoundTime != l) {
                        level.func_184133_a(null, pos, EtchedSounds.UI_ETCHER_TAKE_RESULT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        EtchingMenu.this.lastSoundTime = l;
                    }
                });
                return super.func_190901_a(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, x + y * 9 + 9, 8 + x * 18, 98 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 156));
        }
        this.func_216958_a(this.labelIndex);
    }

    private static void checkStatus(String url) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        httpURLConnection.setRequestMethod("HEAD");
        httpURLConnection.setInstanceFollowRedirects(true);
        Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        }
        String contentType = httpURLConnection.getContentType();
        if (!VALID_FORMATS.contains(contentType)) {
            throw new IOException("Unsupported Content-Type: " + contentType);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((level, pos) -> this.func_193327_a(player, (World)level, this.input));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return EtchingMenu.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)EtchedBlocks.ETCHING_TABLE.get());
    }

    public boolean func_75140_a(PlayerEntity player, int index) {
        if (index >= 0 && index < EtchedMusicDiscItem.LabelPattern.values().length) {
            this.labelIndex.func_221494_a(index);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.func_75216_d()) {
            ItemStack itemStack2 = slot.func_75211_c();
            itemStack = itemStack2.func_77946_l();
            if (index < 3 ? !this.func_75135_a(itemStack2, 3, this.field_75151_b.size(), true) : !this.func_75135_a(itemStack2, 0, 3, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack2.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack2.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemStack2);
        }
        return itemStack;
    }

    public void func_75130_a(IInventory container) {
        ItemStack discStack = this.discSlot.func_75211_c();
        ItemStack labelStack = this.labelSlot.func_75211_c();
        ItemStack resultStack = this.resultSlot.func_75211_c();
        if (resultStack.func_190926_b() && labelStack.func_190926_b()) {
            if (!discStack.func_190926_b() && discStack.func_77973_b() == EtchedItems.ETCHED_MUSIC_DISC.get()) {
                this.labelIndex.func_221494_a(EtchedMusicDiscItem.getPattern(discStack).ordinal());
            } else {
                this.labelIndex.func_221494_a(0);
            }
        }
        this.setupResultSlot();
        super.func_75130_a(container);
    }

    private void setupResultSlot() {
        if (this.player.field_70170_p.func_201670_d()) {
            return;
        }
        if (this.currentRequest != null && !this.currentRequest.isDone() && this.urlId == this.currentRequestId) {
            return;
        }
        EtchedMessages.PLAY.sendTo((ServerPlayerEntity)this.player, (PollinatedPacket)new ClientboundInvalidEtchUrlPacket(""));
        this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        if (this.labelIndex.func_221495_b() >= 0 && this.labelIndex.func_221495_b() < EtchedMusicDiscItem.LabelPattern.values().length) {
            ItemStack discStack = this.discSlot.func_75211_c();
            ItemStack labelStack = this.labelSlot.func_75211_c();
            if (discStack.func_77973_b() == EtchedItems.ETCHED_MUSIC_DISC.get() || !discStack.func_190926_b() && !labelStack.func_190926_b()) {
                if (this.url == null && !discStack.func_190926_b()) {
                    this.url = PlayableRecord.getStackAlbum(discStack).map(TrackData::getUrl).orElse(null);
                }
                if (!TrackData.isValidURL(this.url)) {
                    return;
                }
                int currentId = this.currentRequestId = this.urlId;
                this.currentRequest = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    ItemStack resultStack = new ItemStack((IItemProvider)EtchedItems.ETCHED_MUSIC_DISC.get());
                    resultStack.func_190920_e(1);
                    int discColor = 0x515151;
                    int primaryLabelColor = 0xFFFFFF;
                    int secondaryLabelColor = 0xFFFFFF;
                    TrackData[] data = new TrackData[]{TrackData.EMPTY};
                    if (discStack.func_77973_b() == EtchedItems.ETCHED_MUSIC_DISC.get()) {
                        discColor = EtchedMusicDiscItem.getDiscColor(discStack);
                        primaryLabelColor = EtchedMusicDiscItem.getLabelPrimaryColor(discStack);
                        secondaryLabelColor = EtchedMusicDiscItem.getLabelSecondaryColor(discStack);
                        data = PlayableRecord.getStackMusic(discStack).orElse(data);
                    }
                    if (data.length == 1 && !labelStack.func_190926_b()) {
                        data[0] = data[0].withTitle(MusicLabelItem.getTitle(labelStack)).withArtist(MusicLabelItem.getAuthor(labelStack));
                    }
                    if (SoundSourceManager.isValidUrl(this.url)) {
                        try {
                            data = (TrackData[])((CompletableFuture)DATA_CACHE.get((Object)this.url, () -> SoundSourceManager.resolveTracks(this.url, null, Proxy.NO_PROXY))).join();
                        }
                        catch (Exception e) {
                            if (!this.player.field_70170_p.func_201670_d()) {
                                EtchedMessages.PLAY.sendTo((ServerPlayerEntity)this.player, (PollinatedPacket)new ClientboundInvalidEtchUrlPacket(e instanceof CompletionException ? e.getCause().getMessage() : e.getMessage()));
                            }
                            if (e instanceof CompletionException) {
                                throw (CompletionException)e;
                            }
                            throw new CompletionException(e);
                        }
                    }
                    if (!TrackData.isLocalSound(this.url)) {
                        try {
                            EtchingMenu.checkStatus(this.url);
                            data = new TrackData[]{data[0].withUrl(this.url)};
                        }
                        catch (UnknownHostException e) {
                            if (!this.player.field_70170_p.func_201670_d()) {
                                EtchedMessages.PLAY.sendTo((ServerPlayerEntity)this.player, (PollinatedPacket)new ClientboundInvalidEtchUrlPacket("Unknown host: " + this.url));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                        catch (Exception e) {
                            if (!this.player.field_70170_p.func_201670_d()) {
                                EtchedMessages.PLAY.sendTo((ServerPlayerEntity)this.player, (PollinatedPacket)new ClientboundInvalidEtchUrlPacket(e.getLocalizedMessage()));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                    }
                    if (discStack.func_77973_b() instanceof BlankMusicDiscItem) {
                        discColor = ((BlankMusicDiscItem)discStack.func_77973_b()).func_200886_f(discStack);
                    }
                    if (labelStack.func_77973_b() instanceof MusicLabelItem) {
                        secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(labelStack);
                    } else if (labelStack.func_77973_b() instanceof ComplexMusicLabelItem) {
                        primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(labelStack);
                        secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(labelStack);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        TrackData trackData = data[i];
                        if (trackData.getArtist().equals(TrackData.EMPTY.getArtist())) {
                            trackData = trackData.withArtist(MusicLabelItem.getAuthor(labelStack));
                        }
                        if (TrackData.isLocalSound(this.url)) {
                            trackData = trackData.withUrl(new ResourceLocation(this.url).toString());
                        }
                        data[i] = trackData;
                    }
                    EtchedMusicDiscItem.setMusic(resultStack, data);
                    EtchedMusicDiscItem.setColor(resultStack, discColor, primaryLabelColor, secondaryLabelColor);
                    EtchedMusicDiscItem.setPattern(resultStack, EtchedMusicDiscItem.LabelPattern.values()[this.labelIndex.func_221495_b()]);
                    return resultStack;
                }, (Executor)HTTPUtil.field_180193_a).thenAcceptAsync(resultStack -> {
                    if (this.urlId == currentId && !ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)this.resultSlot.func_75211_c()) && !ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)this.discSlot.func_75211_c())) {
                        this.resultSlot.func_75215_d(resultStack);
                        ++this.urlId;
                        this.urlId %= 1000;
                        this.func_75142_b();
                    }
                }, (Executor)this.player.field_70170_p.func_73046_m())).exceptionally(e -> {
                    e.printStackTrace();
                    return null;
                });
            }
        }
    }

    public int getLabelIndex() {
        return this.labelIndex.func_221495_b();
    }

    public void setUrl(String string) {
        if (!Objects.equals(this.url, string)) {
            this.url = string;
            ++this.urlId;
            this.urlId %= 1000;
            this.setupResultSlot();
        }
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"audio/wav", "audio/x-wav", "audio/opus", "application/ogg", "audio/ogg", "audio/mpeg", "application/octet-stream"});
        VALID_FORMATS = builder.build();
    }
}

