/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.block;

import gg.moonflower.etched.common.blockentity.RadioBlockEntity;
import gg.moonflower.etched.common.menu.RadioMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RadioBlock
extends ContainerBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty PORTAL = BooleanProperty.func_177716_a((String)"portal");
    private static final VoxelShape X_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)8.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)8.0, (double)11.0);
    private static final VoxelShape ROTATED_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final ITextComponent CONTAINER_TITLE = new TranslationTextComponent("container.etched.radio");

    public RadioBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(0))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PORTAL, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        if (level.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(interactionHand);
        if (stack.func_77973_b() == Items.field_222070_lD && !((Boolean)state.func_177229_b((Property)PORTAL)).booleanValue()) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)PORTAL, (Comparable)Boolean.valueOf(true)), 3);
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(state.func_215699_b(level, pos)).ifPresent(__ -> {
            String url = "";
            TileEntity be = level.func_175625_s(pos);
            if (be instanceof RadioBlockEntity) {
                url = ((RadioBlockEntity)be).getUrl();
            }
            EtchedMessages.PLAY.sendTo((ServerPlayerEntity)player, (PollinatedPacket)new ClientboundSetUrlPacket(url));
        });
        return ActionResultType.CONSUME;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)((180.0f + context.func_195990_h()) * 16.0f / 360.0f) + 0.5)) & 0xF))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public void func_220069_a(BlockState blockState, World level, BlockPos pos, Block block, BlockPos blockPos2, boolean bl) {
        boolean bl2;
        if (!level.func_201670_d() && (bl2 = ((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) != level.func_175640_z(pos)) {
            level.func_180501_a(pos, (BlockState)blockState.func_235896_a_((Property)POWERED), 2);
            level.func_184138_a(pos, blockState, level.func_180495_p(pos), 3);
        }
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity blockEntity = level.func_175625_s(pos);
            if (blockEntity instanceof RadioBlockEntity) {
                if (((RadioBlockEntity)blockEntity).isPlaying()) {
                    level.func_217379_c(1010, pos, 0);
                }
                IClearable.func_213131_a((Object)blockEntity);
            }
            super.func_196243_a(state, level, pos, newState, moving);
        }
    }

    public INamedContainerProvider func_220052_b(BlockState blockState, World level, BlockPos blockPos) {
        TileEntity blockEntity = level.func_175625_s(blockPos);
        return new SimpleNamedContainerProvider((menuId, playerInventory, player) -> new RadioMenu(menuId, playerInventory, IWorldPosCallable.func_221488_a((World)level, (BlockPos)blockPos), blockEntity instanceof RadioBlockEntity ? ((RadioBlockEntity)blockEntity)::setUrl : url -> {}), CONTAINER_TITLE);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext collisionContext) {
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (rotation % 8 == 0) {
            return Z_SHAPE;
        }
        if (rotation % 8 == 4) {
            return X_SHAPE;
        }
        return ROTATED_SHAPE;
    }

    public boolean func_220074_n(BlockState blockState) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rotation.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirror.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public TileEntity func_196283_a_(IBlockReader level) {
        return new RadioBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION, POWERED, PORTAL});
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, PathType pathComputationType) {
        return false;
    }

    public ItemStack func_185473_a(IBlockReader level, BlockPos pos, BlockState state) {
        return new ItemStack((Boolean)state.func_177229_b((Property)PORTAL) != false ? (IItemProvider)EtchedBlocks.PORTAL_RADIO_ITEM.get() : (IItemProvider)EtchedBlocks.RADIO.get());
    }

    public void func_180655_c(BlockState state, World level, BlockPos pos, Random random) {
        if (!((Boolean)Etched.CLIENT_CONFIG.showNotes.get()).booleanValue() || !level.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            return;
        }
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof RadioBlockEntity)) {
            return;
        }
        RadioBlockEntity radio = (RadioBlockEntity)blockEntity;
        if (radio.getUrl() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Map<BlockPos, ISound> sounds = ((LevelRendererAccessor)minecraft.field_71438_f).getPlayingRecords();
        if (sounds.containsKey(pos) && minecraft.func_147118_V().func_215294_c(sounds.get(pos))) {
            level.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.7, (double)pos.func_177952_p() + 0.5, (double)random.nextInt(25) / 24.0, 0.0, 0.0);
        }
    }
}

