/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EditMusicLabelScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("etched", "textures/gui/edit_music_label.png");
    private static final ResourceLocation LABEL = new ResourceLocation("etched", "textures/gui/label.png");
    private static final TranslationTextComponent TITLE_COMPONENT = new TranslationTextComponent("screen.etched.edit_music_label.title");
    private static final TranslationTextComponent AUTHOR_COMPONENT = new TranslationTextComponent("screen.etched.edit_music_label.author");
    private final PlayerEntity player;
    private final Hand hand;
    private final ItemStack labelStack;
    private final int imageWidth = 176;
    private final int imageHeight = 139;
    private Button doneButton;
    private TextFieldWidget title;
    private TextFieldWidget author;

    public EditMusicLabelScreen(PlayerEntity player, Hand hand, ItemStack stack) {
        super(NarratorChatListener.field_216868_a);
        this.player = player;
        this.hand = hand;
        this.labelStack = stack;
    }

    protected void func_231160_c_() {
        int leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        int topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.doneButton = new Button(leftPos, topPos + this.imageHeight + 5, this.imageWidth, 20, DialogTexts.field_240632_c_, button -> {
            this.saveChanges();
            this.field_230706_i_.func_147108_a(null);
        });
        this.func_230480_a_((Widget)this.doneButton);
        this.title = new TextFieldWidget(this.field_230712_o_, leftPos + 10, topPos + 91, 154, 10, (ITextComponent)TITLE_COMPONENT);
        this.title.func_146180_a(SimpleMusicLabelItem.getTitle(this.labelStack));
        this.title.func_146204_h(-1);
        this.title.func_146193_g(-1);
        this.title.func_146203_f(128);
        this.title.func_146185_a(false);
        this.title.func_146205_d(true);
        this.title.func_146195_b(true);
        this.func_231035_a_((IGuiEventListener)this.title);
        this.author = new TextFieldWidget(this.field_230712_o_, leftPos + 10, topPos + 121, 154, 10, (ITextComponent)AUTHOR_COMPONENT);
        this.author.func_146180_a(SimpleMusicLabelItem.getAuthor(this.labelStack));
        this.author.func_146204_h(-1);
        this.author.func_146193_g(-1);
        this.author.func_146203_f(128);
        this.author.func_146185_a(false);
        this.author.func_146205_d(true);
        this.title.func_212954_a(string -> {
            if ((this.author.func_146179_b().isEmpty() || string.isEmpty()) && this.doneButton.field_230693_o_) {
                this.doneButton.field_230693_o_ = false;
            } else if (!(this.author.func_146179_b().isEmpty() || string.isEmpty() || this.doneButton.field_230693_o_)) {
                this.doneButton.field_230693_o_ = true;
            }
        });
        this.func_230480_a_((Widget)this.title);
        this.author.func_212954_a(string -> {
            if ((this.title.func_146179_b().isEmpty() || string.isEmpty()) && this.doneButton.field_230693_o_) {
                this.doneButton.field_230693_o_ = false;
            } else if (!(this.title.func_146179_b().isEmpty() || string.isEmpty() || this.doneButton.field_230693_o_)) {
                this.doneButton.field_230693_o_ = true;
            }
        });
        this.func_230480_a_((Widget)this.author);
    }

    public void func_231152_a_(Minecraft minecraft, int i, int j) {
        String title = this.title.func_146179_b();
        String author = this.author.func_146179_b();
        boolean titleFocused = this.title.func_230999_j_();
        boolean authorFocused = this.author.func_230999_j_();
        IGuiEventListener focused = this.func_241217_q_();
        this.func_231158_b_(minecraft, i, j);
        this.title.func_146180_a(title);
        this.title.func_146195_b(titleFocused);
        this.author.func_146180_a(author);
        this.author.func_146195_b(authorFocused);
        this.func_231035_a_(focused);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        this.title.func_146178_a();
        this.author.func_146178_a();
    }

    protected void renderBg(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
        int primaryLabelColor;
        this.func_230446_a_(poseStack);
        int leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        int topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(poseStack, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)TITLE_COMPONENT, (float)(leftPos + 7), (float)(topPos + 77), 0x404040);
        this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)AUTHOR_COMPONENT, (float)(leftPos + 7), (float)(topPos + 77 + 30), 0x404040);
        int secondaryLabelColor = primaryLabelColor = 0xFFFFFF;
        if (this.labelStack.func_77973_b() instanceof MusicLabelItem) {
            secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(this.labelStack);
        } else if (this.labelStack.func_77973_b() instanceof ComplexMusicLabelItem) {
            primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(this.labelStack);
            secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(this.labelStack);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LABEL);
        RenderSystem.color4f((float)((float)(primaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        this.func_238474_b_(poseStack, leftPos, topPos, 0, 0, this.imageWidth, 70);
        RenderSystem.color4f((float)((float)(secondaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        this.func_238474_b_(poseStack, leftPos, topPos, 0, 70, this.imageWidth, 70);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBg(poseStack, mouseX, mouseY, partialTick);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTick);
    }

    private void saveChanges() {
        String author = this.author.func_146179_b().trim();
        String title = this.title.func_146179_b().trim();
        SimpleMusicLabelItem.setTitle(this.labelStack, title);
        SimpleMusicLabelItem.setAuthor(this.labelStack, author);
        int slot = this.hand == Hand.MAIN_HAND ? this.player.field_71071_by.field_70461_c : 40;
        EtchedMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundEditMusicLabelPacket(slot, author, title));
    }
}

