/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AlbumJukeboxScreen
extends ContainerScreen<AlbumJukeboxMenu> {
    private static final ResourceLocation CONTAINER_LOCATION = new ResourceLocation("textures/gui/container/dispenser.png");
    private static final ITextComponent NOW_PLAYING = new TranslationTextComponent("screen.etched.album_jukebox.now_playing").func_240699_a_(TextFormatting.YELLOW);
    private int playingIndex;
    private int playingTrack;

    public AlbumJukeboxScreen(AlbumJukeboxMenu dispenserMenu, PlayerInventory inventory, ITextComponent component) {
        super((Container)dispenserMenu, inventory, component);
    }

    private void update(boolean next) {
        ClientWorld level = this.field_230706_i_.field_71441_e;
        if (level == null || !((AlbumJukeboxMenu)this.field_147002_h).isInitialized()) {
            return;
        }
        TileEntity blockEntity = level.func_175625_s(((AlbumJukeboxMenu)this.field_147002_h).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity) || !((AlbumJukeboxBlockEntity)blockEntity).isPlaying()) {
            return;
        }
        AlbumJukeboxBlockEntity albumJukebox = (AlbumJukeboxBlockEntity)blockEntity;
        int oldIndex = albumJukebox.getPlayingIndex();
        int oldTrack = albumJukebox.getTrack();
        if (next) {
            albumJukebox.next();
        } else {
            albumJukebox.previous();
        }
        if ((albumJukebox.getPlayingIndex() == oldIndex && albumJukebox.getTrack() != oldTrack || albumJukebox.recalculatePlayingIndex(!next)) && albumJukebox.getPlayingIndex() != -1) {
            SoundTracker.playAlbum(albumJukebox, albumJukebox.func_195044_w(), level, ((AlbumJukeboxMenu)this.field_147002_h).getPos(), true);
            EtchedMessages.PLAY.sendToServer((PollinatedPacket)new SetAlbumJukeboxTrackPacket(albumJukebox.getPlayingIndex(), albumJukebox.getTrack()));
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int buttonPadding = 6;
        StringTextComponent last = new StringTextComponent("Last");
        StringTextComponent next = new StringTextComponent("Next");
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 7 + (54 - font.func_238414_a_((ITextProperties)last)) / 2 - buttonPadding, this.field_147009_r + 33, font.func_238414_a_((ITextProperties)last) + 2 * buttonPadding, 20, (ITextComponent)last, b -> this.update(false)));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 115 + (54 - font.func_238414_a_((ITextProperties)last)) / 2 - buttonPadding, this.field_147009_r + 33, font.func_238414_a_((ITextProperties)next) + 2 * buttonPadding, 20, (ITextComponent)next, b -> this.update(true)));
        this.field_238742_p_ = (this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_)) / 2;
    }

    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, i, j, f);
        this.func_230459_a_(poseStack, i, j);
    }

    protected void func_230450_a_(MatrixStack poseStack, float f, int i, int j) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(CONTAINER_LOCATION);
        int guiLeft = (this.field_230708_k_ - this.field_146999_f) / 2;
        int guiTop = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(poseStack, guiLeft, guiTop, 0, 0, this.field_146999_f, this.field_147000_g);
        this.playingIndex = -1;
        this.playingTrack = 0;
        ClientWorld level = this.field_230706_i_.field_71441_e;
        if (level == null || !((AlbumJukeboxMenu)this.field_147002_h).isInitialized()) {
            return;
        }
        TileEntity blockEntity = level.func_175625_s(((AlbumJukeboxMenu)this.field_147002_h).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        this.playingIndex = ((AlbumJukeboxBlockEntity)blockEntity).getPlayingIndex();
        this.playingTrack = ((AlbumJukeboxBlockEntity)blockEntity).getTrack();
        if (this.playingIndex != -1) {
            int x = this.playingIndex % 3;
            int y = this.playingIndex / 3;
            this.func_238468_a_(poseStack, guiLeft + 62 + x * 18, guiTop + 17 + y * 18, guiLeft + 78 + x * 18, guiTop + 33 + y * 18, 1022820096, 1022820096);
        }
    }

    protected void func_230459_a_(MatrixStack poseStack, int i, int j) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            ItemStack stack = this.field_147006_u.func_75211_c();
            List tooltip = this.func_231151_a_(stack);
            if (this.field_147006_u.field_75222_d == this.playingIndex) {
                if (this.playingTrack >= 0 && PlayableRecord.getStackTrackCount(stack) > 0) {
                    Optional<TrackData[]> optional = PlayableRecord.getStackMusic(stack).filter(tracks -> this.playingTrack < ((TrackData[])tracks).length);
                    if (optional.isPresent()) {
                        TrackData track = optional.get()[this.playingTrack];
                        tooltip.add(NOW_PLAYING.func_230532_e_().func_240702_b_(": ").func_230529_a_(track.getDisplayName()).func_240702_b_(" (" + (this.playingTrack + 1) + "/" + optional.get().length + ")"));
                    } else {
                        tooltip.add(NOW_PLAYING);
                    }
                } else {
                    tooltip.add(NOW_PLAYING);
                }
            }
            this.func_243308_b(poseStack, tooltip, i, j);
        }
    }
}

