/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import gg.moonflower.etched.client.render.item.AlbumCoverItemRenderer;
import gg.moonflower.etched.client.render.item.AlbumImageProcessor;
import gg.moonflower.pollen.api.util.OnlineRequest;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryCache;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.texture.NativeImage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AlbumTextureCache
implements FileCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Executor executor;
    private final long cacheTime;
    private final TimeUnit cacheTimeUnit;

    public AlbumTextureCache(Executor executor, long cacheTime, TimeUnit cacheTimeUnit) {
        this.executor = executor;
        this.cacheTime = cacheTime;
        this.cacheTimeUnit = cacheTimeUnit;
    }

    public CompletableFuture<Path> requestResource(String url, boolean ignoreMissing) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return GeometryCache.getPath((String)url, (long)this.cacheTime, (TimeUnit)this.cacheTimeUnit, s -> {
                    FileInputStream fileInputStream;
                    block9: {
                        InputStream is = OnlineRequest.get((String)url);
                        try {
                            final Path tempFile = Files.createTempFile("etched-album-cover", null, new FileAttribute[0]);
                            AlbumImageProcessor.apply(NativeImage.func_195713_a((InputStream)is), AlbumCoverItemRenderer.getOverlayImage(), 1).func_209270_a(tempFile);
                            fileInputStream = new FileInputStream(tempFile.toFile()){

                                @Override
                                public void close() throws IOException {
                                    super.close();
                                    Files.delete(tempFile);
                                }
                            };
                            if (is == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                if (!ignoreMissing) {
                                    LOGGER.error("Failed to read data from '" + url + "'", (Throwable)e);
                                }
                                return null;
                            }
                        }
                        is.close();
                    }
                    return fileInputStream;
                });
            }
            catch (Exception e) {
                if (!ignoreMissing) {
                    LOGGER.error("Failed to fetch resource from '" + url + "'", (Throwable)e);
                }
                return null;
            }
        }, this.executor);
    }
}

