/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AlbumImageProcessor {
    private static final int COLOR_DIVISIONS = 16;
    private static final float[] POW22 = (float[])Util.func_200696_a((Object)new float[256], fs -> {
        for (int i = 0; i < ((float[])fs).length; ++i) {
            fs[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    });

    public static NativeImage apply(NativeImage image, NativeImage overlay, int border) {
        NativeImage nativeImage2 = new NativeImage(overlay.func_195702_a(), overlay.func_195714_b(), true);
        int k = nativeImage2.func_195702_a();
        int l = nativeImage2.func_195714_b();
        int w = overlay.func_195702_a() / 16;
        int h = overlay.func_195714_b() / 16;
        float xFactor = (float)image.func_195702_a() / (float)(overlay.func_195702_a() * 2);
        float yFactor = (float)image.func_195714_b() / (float)(overlay.func_195714_b() * 2);
        for (int m = border * w; m < k - border * w; ++m) {
            for (int n = border * h; n < l - border * h; ++n) {
                int x1 = (int)(xFactor * (float)m * 2.0f);
                int x2 = (int)(xFactor * (float)(m * 2 + 1));
                int y1 = (int)(yFactor * (float)n * 2.0f);
                int y2 = (int)(yFactor * (float)(n * 2 + 1));
                int baseColor = AlbumImageProcessor.alphaBlend(image.func_195709_a(x1, y1), image.func_195709_a(x2, y1), image.func_195709_a(x1, y2), image.func_195709_a(x2, y2));
                int overlayColor = overlay.func_195709_a(m, n);
                nativeImage2.func_195700_a(m, n, baseColor & 0xFF000000 | AlbumImageProcessor.multiply(baseColor, overlayColor, 16) | AlbumImageProcessor.multiply(baseColor, overlayColor, 8) | AlbumImageProcessor.multiply(baseColor, overlayColor, 0));
            }
        }
        nativeImage2.func_195715_a(w, h, w, h, 0);
        nativeImage2.func_195715_a(overlay.func_195702_a() - w * 2, h, w, h, 0);
        nativeImage2.func_195715_a(w, overlay.func_195714_b() - h * 2, w, h, 0);
        nativeImage2.func_195715_a(overlay.func_195702_a() - w * 2, overlay.func_195714_b() - h * 2, w, h, 0);
        image.close();
        return nativeImage2;
    }

    private static int multiply(int col1, int col2, int bitOffset) {
        return ((int)((float)(col1 >> bitOffset & 0xFF) * ((float)(col2 >> bitOffset & 0xFF) / 255.0f) / 16.0f) * 16 & 0xFF) << bitOffset;
    }

    private static int alphaBlend(int col1, int col2, int col3, int col4) {
        int o = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 16);
        int p = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 8);
        int q = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 0);
        return 0xFF000000 | o << 16 | p << 8 | q;
    }

    private static int gammaBlend(int col1, int col2, int col3, int col4, int bitOffset) {
        float f = AlbumImageProcessor.getPow22(col1 >> bitOffset);
        float g = AlbumImageProcessor.getPow22(col2 >> bitOffset);
        float h = AlbumImageProcessor.getPow22(col3 >> bitOffset);
        float i = AlbumImageProcessor.getPow22(col4 >> bitOffset);
        float j = (float)((double)((float)Math.pow((double)(f + g + h + i) * 0.25, 0.45454545454545453)));
        return (int)((double)j * 255.0);
    }

    private static float getPow22(int val) {
        return POW22[val & 0xFF];
    }
}

