/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.client.render.item.ImageAlbumCover;
import gg.moonflower.etched.client.render.item.ModelAlbumCover;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;

public class AlbumCoverItemRenderer
extends ReloadListener<CoverData>
implements DynamicItemRenderer,
PollinatedPreparableReloadListener {
    public static final AlbumCoverItemRenderer INSTANCE = new AlbumCoverItemRenderer();
    public static final String FOLDER_NAME = "etched_album_cover";
    private static final ModelResourceLocation BLANK_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/blank"), "inventory");
    private static final ModelResourceLocation DEFAULT_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/default"), "inventory");
    private static final ResourceLocation ALBUM_COVER_OVERLAY = new ResourceLocation("etched", "textures/item/album_cover_overlay.png");
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final BlockModel MODEL = BlockModel.func_178294_a((String)"{\"gui_light\":\"front\",\"textures\":{\"layer0\":\"texture\"},\"display\":{\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,2,0],\"scale\":[0.5,0.5,0.5]},\"head\":{\"rotation\":[0,180,0],\"translation\":[0,13,7],\"scale\":[1,1,1]},\"thirdperson_righthand\":{\"rotation\":[0,0,0],\"translation\":[0,3,1],\"scale\":[0.55,0.55,0.55]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[0.68,0.68,0.68]},\"fixed\":{\"rotation\":[0,180,0],\"scale\":[1,1,1]}}}");
    private final Map<CompoundNBT, CompletableFuture<ModelData>> covers = new HashMap<CompoundNBT, CompletableFuture<ModelData>>();
    private CoverData data = null;

    private AlbumCoverItemRenderer() {
    }

    public static void init() {
        ResourceRegistry.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (PollinatedPreparableReloadListener)INSTANCE);
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> INSTANCE.close());
    }

    public static NativeImage getOverlayImage() {
        return AlbumCoverItemRenderer.INSTANCE.data.overlay.getImage();
    }

    private static void renderModelLists(IBakedModel model, int combinedLight, int combinedOverlay, MatrixStack matrixStack, IVertexBuilder buffer) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.func_200117_a(null, direction, random), combinedLight, combinedOverlay);
        }
        random.setSeed(42L);
        AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.func_200117_a(null, null, random), combinedLight, combinedOverlay);
    }

    private static void renderQuadList(MatrixStack matrixStack, IVertexBuilder buffer, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        MatrixStack.Entry pose = matrixStack.func_227866_c_();
        for (BakedQuad bakedQuad : quads) {
            buffer.func_227889_a_(pose, bakedQuad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
    }

    private static NativeImage getCoverOverlay(IResourceManager resourceManager) {
        NativeImage nativeImage;
        block11: {
            IResource resource = resourceManager.func_199002_a(ALBUM_COVER_OVERLAY);
            try {
                nativeImage = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
                if (resource == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    NativeImage nativeImage2 = new NativeImage(16, 16, false);
                    for (int k = 0; k < 16; ++k) {
                        for (int l = 0; l < 16; ++l) {
                            if (k < 8 ^ l < 8) {
                                nativeImage2.func_195700_a(l, k, -524040);
                                continue;
                            }
                            nativeImage2.func_195700_a(l, k, -16777216);
                        }
                    }
                    nativeImage2.func_195711_f();
                    return nativeImage2;
                }
            }
            resource.close();
        }
        return nativeImage;
    }

    private void close() {
        this.covers.values().forEach(future -> future.thenAcceptAsync(data -> {
            if (!this.data.is((ModelData)data)) {
                data.close();
            }
        }, task -> RenderSystem.recordRenderCall(task::run)));
        this.covers.clear();
    }

    protected CoverData prepare(IResourceManager resourceManager, IProfiler profiler) {
        return new CoverData(AlbumCoverItemRenderer.getCoverOverlay(resourceManager));
    }

    protected void apply(CoverData data, IResourceManager resourceManager, IProfiler profiler) {
        if (this.data != null) {
            this.data.close();
        }
        this.data = data;
        this.close();
    }

    public void render(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, int combinedOverlay) {
        if (stack.func_190926_b()) {
            return;
        }
        ModelData model = stack.func_179543_a("CoverRecord") == null ? this.data.blank : this.covers.computeIfAbsent(stack.func_179543_a("CoverRecord"), __ -> {
            ItemStack coverStack = AlbumCoverItem.getCoverStack(stack).orElse(ItemStack.field_190927_a);
            if (!coverStack.func_190926_b() && coverStack.func_77973_b() instanceof PlayableRecord) {
                return ((CompletableFuture)((PlayableRecord)coverStack.func_77973_b()).getAlbumCover(coverStack, Minecraft.func_71410_x().func_110437_J(), Minecraft.func_71410_x().func_195551_G()).thenApply(cover -> ModelData.of(cover).orElse(this.data.defaultCover))).exceptionally(e -> {
                    e.printStackTrace();
                    return this.data.defaultCover;
                });
            }
            return CompletableFuture.completedFuture(this.data.blank);
        }).getNow(this.data.defaultCover);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        model.render(stack, transformType, matrixStack, buffer, packedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getPollenId() {
        return new ResourceLocation("etched", "builtin_album_cover");
    }

    public static class CoverData {
        private final DynamicModelData overlay;
        private final ModelData blank;
        private final ModelData defaultCover;

        private CoverData(NativeImage overlay) {
            this.overlay = new DynamicModelData(overlay);
            this.blank = new BakedModelData(BLANK_ALBUM_COVER);
            this.defaultCover = new BakedModelData(DEFAULT_ALBUM_COVER);
        }

        public void close() {
            this.overlay.close();
            this.blank.close();
            this.defaultCover.close();
        }

        public boolean is(ModelData data) {
            return this.overlay == data || this.blank == data || this.defaultCover == data;
        }
    }

    private static class DynamicModelData
    extends TextureAtlasSprite
    implements ModelData {
        private static final AtlasTexture ATLAS = new AtlasTexture(new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())));
        private IBakedModel model;

        private DynamicModelData(NativeImage image) {
            super(ATLAS, new TextureAtlasSprite.Info(new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())), image.func_195702_a(), image.func_195714_b(), AnimationMetadataSection.field_229300_b_), 0, image.func_195702_a(), image.func_195714_b(), 0, 0, image);
        }

        @Override
        public void render(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, int combinedOverlay) {
            IBakedModel model = this.getModel();
            if (model.func_188618_c()) {
                return;
            }
            model.func_177552_f().func_181688_b(transformType).func_228830_a_(transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, matrixStack);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            AlbumCoverItemRenderer.renderModelLists(model, packedLight, combinedOverlay, matrixStack, ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)RenderType.func_228638_b_((ResourceLocation)this.func_195668_m()), (boolean)false, (boolean)stack.func_77962_s()));
        }

        private IBakedModel getModel() {
            if (this.model == null) {
                IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
                profiler.func_76320_a("buildAlbumCoverModel");
                this.model = ITEM_MODEL_GENERATOR.func_209579_a(material -> this, MODEL).func_228813_a_(null, MODEL, material -> this, (IModelTransform)ModelRotation.X0_Y0, this.func_195668_m(), false);
                profiler.func_76319_b();
            }
            if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(this.func_195668_m()) == null) {
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(this.func_195668_m(), (Texture)new DynamicTexture(this.field_195670_c[0]));
            }
            return this.model;
        }

        public NativeImage getImage() {
            return this.field_195670_c[0];
        }

        public float func_229242_p_() {
            return 0.0f;
        }

        public IVertexBuilder func_229230_a_(IVertexBuilder buffer) {
            return buffer;
        }

        @Override
        public void close() {
            super.close();
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.func_195668_m());
        }
    }

    private static interface ModelData {
        public static Optional<ModelData> of(AlbumCover cover) {
            if (cover instanceof ModelAlbumCover) {
                return Optional.of(new BakedModelData(((ModelAlbumCover)cover).getModel()));
            }
            if (cover instanceof ImageAlbumCover) {
                return Optional.of(new DynamicModelData(((ImageAlbumCover)cover).getImage()));
            }
            return Optional.empty();
        }

        public void render(ItemStack var1, ItemCameraTransforms.TransformType var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, int var6);

        public void close();
    }

    private static class BakedModelData
    implements ModelData {
        private final ModelResourceLocation model;
        private boolean rendering;

        private BakedModelData(ModelResourceLocation model) {
            this.model = model;
        }

        @Override
        public void render(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, int combinedOverlay) {
            ModelManager modelManager = Minecraft.func_71410_x().func_209506_al();
            IBakedModel model = this.rendering ? modelManager.func_174951_a() : modelManager.func_174953_a(this.model);
            this.rendering = true;
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, transformType, transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, matrixStack, buffer, packedLight, combinedOverlay, model);
            this.rendering = false;
        }

        @Override
        public void close() {
        }
    }
}

