/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundStreamModifier;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.stream.MonoWrapper;
import gg.moonflower.etched.api.sound.stream.RawAudioStream;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.HeaderInputStream;
import gg.moonflower.etched.api.util.Mp3InputStream;
import gg.moonflower.etched.api.util.SeekingStream;
import gg.moonflower.etched.api.util.WaveDataReader;
import gg.moonflower.etched.client.sound.EmptyAudioStream;
import gg.moonflower.etched.client.sound.SoundCache;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.OggAudioStream;
import net.minecraft.client.audio.OggAudioStreamWrapper;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AbstractOnlineSoundInstance
extends LocatableSound {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String url;
    private final String subtitle;
    private final int attenuationDistance;
    private final DownloadProgressListener progressListener;
    private final AudioSource.AudioFileType type;
    private final boolean stereo;

    public AbstractOnlineSoundInstance(String url, @Nullable String subtitle, int attenuationDistance, SoundCategory source, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
        super(new ResourceLocation("etched", DigestUtils.sha1Hex((String)url)), source);
        this.url = url;
        this.subtitle = subtitle;
        this.attenuationDistance = attenuationDistance;
        this.progressListener = progressListener;
        this.type = type;
        this.stereo = stereo;
    }

    private static IAudioStream getStream(IAudioStream stream, Sound sound) {
        return sound instanceof SoundStreamModifier ? ((SoundStreamModifier)sound).modifyStream(stream) : new MonoWrapper(stream);
    }

    public SoundEventAccessor func_184366_a(SoundHandler soundManager) {
        SoundEventAccessor weighedSoundEvents = new SoundEventAccessor(this.func_147650_b(), this.subtitle);
        weighedSoundEvents.func_188715_a((ISoundEventAccessor)new OnlineSound(this.func_147650_b(), this.url, this.attenuationDistance, this.progressListener, this.type, this.stereo));
        this.field_184367_a = weighedSoundEvents.func_148720_g();
        return weighedSoundEvents;
    }

    public AbstractOnlineSoundInstance setLoop(boolean loop) {
        this.field_147659_g = loop;
        return this;
    }

    public CompletableFuture<IAudioStream> getStream(AudioStreamManager soundBufferLibrary, Sound sound, boolean loop) {
        if (!(sound instanceof OnlineSound)) {
            return soundBufferLibrary.func_217917_b(sound.func_188721_b(), loop);
        }
        OnlineSound onlineSound = (OnlineSound)sound;
        if (TrackData.isLocalSound(onlineSound.getURL())) {
            SoundEventAccessor weighedSoundEvents = Minecraft.func_71410_x().func_147118_V().func_184398_a(new ResourceLocation(onlineSound.getURL()));
            if (weighedSoundEvents == null) {
                CompletableFuture<IAudioStream> future = new CompletableFuture<IAudioStream>();
                future.completeExceptionally(new FileNotFoundException("Unable to play unknown soundEvent: " + sound.func_188721_b()));
                return future;
            }
            return ((CompletableFuture)soundBufferLibrary.func_217917_b(weighedSoundEvents.func_148720_g().func_188721_b(), loop).thenApply(MonoWrapper::new)).handleAsync((stream, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, Util.func_215072_e());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener(), onlineSound.getAudioFileType()).thenCompose(AudioSource::openStream)).thenApplyAsync(stream -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                HeaderInputStream is;
                byte[] readHeader = new byte[8192];
                int read = IOUtils.read((InputStream)stream, (byte[])readHeader);
                if (read < readHeader.length) {
                    byte[] header = new byte[read];
                    System.arraycopy(readHeader, 0, header, 0, header.length);
                    is = new HeaderInputStream(header, (InputStream)stream);
                } else {
                    is = new HeaderInputStream(readHeader, (InputStream)stream);
                }
                try {
                    return AbstractOnlineSoundInstance.getStream((IAudioStream)(loop ? new OggAudioStreamWrapper(OggAudioStream::new, (InputStream)is) : new OggAudioStream((InputStream)is)), sound);
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to load as OGG", (Throwable)e);
                    ((SeekingStream)is).beginning();
                    try {
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(is);
                        AudioFormat format = ais.getFormat();
                        return AbstractOnlineSoundInstance.getStream((IAudioStream)(loop ? new OggAudioStreamWrapper(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)), sound);
                    }
                    catch (Exception e1) {
                        LOGGER.debug("Failed to load as WAV", (Throwable)e1);
                        ((SeekingStream)is).beginning();
                        try {
                            Mp3InputStream mp3InputStream = new Mp3InputStream(is);
                            return AbstractOnlineSoundInstance.getStream((IAudioStream)(loop ? new OggAudioStreamWrapper(input -> new RawAudioStream(mp3InputStream.getFormat(), input), (InputStream)mp3InputStream) : new RawAudioStream(mp3InputStream.getFormat(), mp3InputStream)), sound);
                        }
                        catch (Exception e2) {
                            LOGGER.debug("Failed to load as MP3", (Throwable)e2);
                            IOUtils.closeQuietly((InputStream)is);
                            e.printStackTrace();
                            e1.printStackTrace();
                            e2.printStackTrace();
                            throw new CompletionException(new UnsupportedAudioFileException("Could not load as OGG, WAV, OR MP3"));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, Util.func_215072_e())).handleAsync((stream, e) -> {
            if (e != null) {
                e.printStackTrace();
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, Util.func_215072_e());
    }

    public static class OnlineSound
    extends Sound
    implements SoundStreamModifier {
        private final String url;
        private final DownloadProgressListener progressListener;
        private final AudioSource.AudioFileType type;
        private final boolean stereo;

        public OnlineSound(ResourceLocation location, String url, int attenuationDistance, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
            super(location.toString(), 1.0f, 1.0f, 1, Sound.Type.FILE, true, false, attenuationDistance);
            this.url = url;
            this.progressListener = progressListener;
            this.type = type;
            this.stereo = stereo;
        }

        public String getURL() {
            return this.url;
        }

        public DownloadProgressListener getProgressListener() {
            return this.progressListener;
        }

        public AudioSource.AudioFileType getAudioFileType() {
            return this.type;
        }

        @Override
        public IAudioStream modifyStream(IAudioStream stream) {
            return this.stereo ? stream : new MonoWrapper(stream);
        }
    }
}

