/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface PlayableRecord {
    public static boolean isPlayableRecord(ItemStack stack) {
        return stack.func_77973_b() instanceof PlayableRecord && ((PlayableRecord)stack.func_77973_b()).canPlay(stack);
    }

    public static boolean canShowMessage(double x, double y, double z) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return player == null || player.func_70092_e(x, y, z) <= 4096.0;
    }

    public static void showMessage(ITextComponent text) {
        Minecraft.func_71410_x().field_71456_v.func_238451_a_(text);
    }

    public static void playEntityRecord(Entity entity, ItemStack record, boolean restart) {
        EtchedMessages.PLAY.sendToTracking(entity, (PollinatedPacket)new ClientboundPlayEntityMusicPacket(record, entity, restart));
    }

    public static void stopEntityRecord(Entity entity) {
        EtchedMessages.PLAY.sendToTracking(entity, (PollinatedPacket)new ClientboundPlayEntityMusicPacket(entity));
    }

    public static Optional<TrackData[]> getStackMusic(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof PlayableRecord)) {
            return Optional.empty();
        }
        return ((PlayableRecord)stack.func_77973_b()).getMusic(stack);
    }

    public static Optional<TrackData> getStackAlbum(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof PlayableRecord)) {
            return Optional.empty();
        }
        return ((PlayableRecord)stack.func_77973_b()).getAlbum(stack);
    }

    public static int getStackTrackCount(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof PlayableRecord)) {
            return 0;
        }
        return ((PlayableRecord)stack.func_77973_b()).getTrackCount(stack);
    }

    default public boolean canPlay(ItemStack stack) {
        return this.getMusic(stack).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Optional<? extends ISound> createEntitySound(ItemStack stack, Entity entity, int track, int attenuationDistance) {
        return track < 0 ? Optional.empty() : this.getMusic(stack).filter(tracks -> track < ((TrackData[])tracks).length).map(tracks -> SoundTracker.getEtchedRecord(tracks[track].getUrl(), tracks[track].getDisplayName(), entity, attenuationDistance, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Optional<? extends ISound> createEntitySound(ItemStack stack, Entity entity, int track) {
        return this.createEntitySound(stack, entity, track, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack var1, Proxy var2, IResourceManager var3);

    public Optional<TrackData[]> getMusic(ItemStack var1);

    public Optional<TrackData> getAlbum(ItemStack var1);

    public int getTrackCount(ItemStack var1);
}

