/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry;

import com.google.common.collect.Lists;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.DropSettings;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class VoidMinerData
extends VLRecipe {
    public static final int TOTAL_TIERS = 8;
    public static final String EMPTY_FOCUS = "empty";
    private volatile CopyOnWriteArrayList<VLID> programs;
    private volatile Ingredient<ItemStack> item;
    private volatile CopyOnWriteArrayList<DropSettings> settings;

    public VoidMinerData(CopyOnWriteArrayList<VLID> programs, Ingredient<ItemStack> item, CopyOnWriteArrayList<DropSettings> settings) {
        this.programs = programs;
        this.item = item;
        this.settings = settings;
    }

    public VoidMinerData(VLID program, Ingredient<ItemStack> item, CopyOnWriteArrayList<DropSettings> settings) {
        this(Lists.newCopyOnWriteArrayList(Collections.singletonList(program)), item, settings);
    }

    public VoidMinerData(PacketBuffer buffer) {
        super(buffer);
    }

    public Ingredient<ItemStack> getItem() {
        return this.item;
    }

    public List<DropSettings> getDropSettings() {
        return this.settings;
    }

    public String toString() {
        return this.programs + " " + this.item.toString() + " " + this.settings.size() + " " + this.settings.toString();
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.programs.size());
        for (VLID id : this.programs) {
            packetBuffer.func_180714_a(id.toString());
        }
        this.item.writePacketData(packetBuffer);
        VoidMinerData.writeAllToPacket(this.settings, packetBuffer);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        int total = packetBuffer.readInt();
        CopyOnWriteArrayList programs = Lists.newCopyOnWriteArrayList();
        for (int i = 0; i < total; ++i) {
            programs.add(VLID.from((String)packetBuffer.func_218666_n()));
        }
        this.programs = programs;
        this.item = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.settings = VoidMinerData.createAllFromPacket(packetBuffer);
    }

    protected boolean canWriteData() {
        if (!this.item.isValid()) {
            return false;
        }
        if (this.programs == null || this.programs.isEmpty()) {
            return false;
        }
        return this.settings != null && !this.settings.isEmpty();
    }

    private static void writeAllToPacket(@NotNull List<DropSettings> drops, PacketBuffer buffer) {
        buffer.writeInt(drops.size());
        for (DropSettings ds : drops) {
            VoidMinerData.writeToPacket(ds, buffer);
        }
    }

    private static CopyOnWriteArrayList<DropSettings> createAllFromPacket(PacketBuffer buffer) {
        CopyOnWriteArrayList settings = Lists.newCopyOnWriteArrayList();
        int i = buffer.readInt();
        for (int ii = 0; ii < i; ++ii) {
            DropSettings ds = VoidMinerData.createFromPacket(buffer);
            if (ds == null) continue;
            settings.add(ds);
        }
        return settings;
    }

    public boolean isValid() {
        return this.item.isValid() && this.programs != null;
    }

    private static DropSettings createFromPacket(PacketBuffer buffer) {
        String focus = buffer.func_218666_n();
        VLID focusID = null;
        if (!focus.equals(EMPTY_FOCUS)) {
            focusID = VLID.from((String)focus);
        }
        boolean dimBlacklist = buffer.readBoolean();
        int dimCount = buffer.readInt();
        CopyOnWriteArrayList dims = Lists.newCopyOnWriteArrayList();
        for (int i = 0; i < dimCount; ++i) {
            String dim = buffer.func_218666_n();
            dims.add(VLID.from((String)dim));
        }
        boolean biomeBlacklist = buffer.readBoolean();
        int biomeCount = buffer.readInt();
        CopyOnWriteArrayList biomes = Lists.newCopyOnWriteArrayList();
        for (int i = 0; i < biomeCount; ++i) {
            String biome = buffer.func_218666_n();
            biomes.add(VLID.from((String)biome));
        }
        CopyOnWriteArrayList<Integer> enabledTiers = VoidMinerData.getEnabled(buffer.readInt(), 8);
        int weight = buffer.readInt();
        return new DropSettings(focusID, dimBlacklist, dims, biomeBlacklist, biomes, enabledTiers, weight);
    }

    private static void writeToPacket(DropSettings ds, PacketBuffer buffer) {
        if (ds.focus == null) {
            buffer.func_180714_a(EMPTY_FOCUS);
        } else {
            buffer.func_180714_a(ds.focus.toString());
        }
        buffer.writeBoolean(ds.blacklistDims);
        buffer.writeInt(ds.dimensions.size());
        for (VLID dimension : ds.dimensions) {
            buffer.func_180714_a(dimension.toString());
        }
        buffer.writeBoolean(ds.blacklistBiomes);
        buffer.writeInt(ds.biomes.size());
        for (VLID biome : ds.biomes) {
            buffer.func_180714_a(biome.toString());
        }
        buffer.writeInt(VoidMinerData.compressEnabled(ds.tiers, 8));
        buffer.writeInt(ds.weight);
    }

    private static int setBit(int input, int position, boolean value) {
        return value ? input | 1 << position : input | 0 << position;
    }

    private static boolean getBit(int var, int position) {
        int bit = var >> position & 1;
        return bit == 1;
    }

    private static CopyOnWriteArrayList<Integer> getEnabled(int input, int maxTiers) {
        CopyOnWriteArrayList ret = Lists.newCopyOnWriteArrayList();
        for (int i = 0; i < maxTiers; ++i) {
            if (!VoidMinerData.getBit(input, i)) continue;
            ret.add(i + 1);
        }
        return ret;
    }

    private static int compressEnabled(List<Integer> tiers, int maxTiers) {
        int ret = 0;
        for (Integer i : tiers) {
            if (i > maxTiers) continue;
            ret = VoidMinerData.setBit(ret, i - 1, true);
        }
        return ret;
    }

    public Collection<VLID> getAllPrograms() {
        return this.programs;
    }
}

