/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergy.m_solar.tile;

import com.valkyrieofnight.envirocore.core.TierInfo;
import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.ccu.PassivePotEnergyCCUTile;
import com.valkyrieofnight.envirocore.m_comp.m_io.tile.IIOTile;
import com.valkyrieofnight.envirocore.m_comp.m_modifier.CModifiersModule;
import com.valkyrieofnight.envirocore.multiblock.io.IForgeEnergyIO;
import com.valkyrieofnight.enviroenergy.m_solar.EESolar;
import com.valkyrieofnight.enviroenergy.m_solar.tile.ISolarCellTile;
import com.valkyrieofnight.enviroenergy.m_solar.ui.SolarCCUContainer;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.util.WorldUtils;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.multiblock.StructureMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SolarCCUTile
extends PassivePotEnergyCCUTile<SolarCCUContainer>
implements IForgeEnergyIO {
    private static double POWER_POWER = 2.2;
    private static int CELL_ENERGY_TICK = 1280;
    protected ContinuousSolarScanner solarScanner;
    protected int totalValidCells = 0;
    protected double efficiency = 0.0;

    public SolarCCUContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        return new SolarCCUContainer(i, playerEntity.field_71071_by, this);
    }

    public static void loadConfig(IConfig cfg) {
        POWER_POWER = cfg.getDouble("production_power", POWER_POWER, new String[0]);
        CELL_ENERGY_TICK = cfg.getInt("production_rate", 128, 128, 128000, new String[0]) * 10;
    }

    public static int getMultiplier(int tier) {
        if (tier <= 0) {
            return 1;
        }
        return (int)Math.pow(2.2, tier - 1);
    }

    public static long getCellGen(int tier) {
        return CELL_ENERGY_TICK * SolarCCUTile.getMultiplier(tier);
    }

    public static long getArrayGen(int tier, int totalCells) {
        return SolarCCUTile.getCellGen(tier) * (long)totalCells;
    }

    public SolarCCUTile(TileEntityType<?> tileEntityTypeIn, int tier) {
        super(tileEntityTypeIn, new UniPotentialBattery(SolarCCUTile.getArrayGen(tier, tier * tier) * 10000L));
        this.setDirection(Direction.UP);
        this.modifierHandler.addScannable(CModifiersModule.PIEZO_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.RADIANT_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.THERMAL_ATTRIBUTE.getID());
    }

    public List<XYZOrientation> getValid() {
        return XYZOrientation.getAllWith((Direction)Direction.UP, (RelativeDirection)RelativeDirection.FORWARD);
    }

    public void queueValidOrientations(Queue<XYZOrientation> orientationQueue) {
        orientationQueue.addAll(this.getValid());
    }

    protected void serverTickFormed() {
        super.serverTickFormed();
        if (this.solarScanner != null) {
            this.solarScanner.tick();
        }
    }

    protected void onMultiblockFormed() {
        super.onMultiblockFormed();
        if (this.solarScanner == null) {
            this.solarScanner = new ContinuousSolarScanner(this, this.getScanRate());
        }
    }

    public int getFEEnergyTick() {
        if (this.isFormed()) {
            return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.getPotentialForTick());
        }
        return 0;
    }

    protected void onProcessTick(int i) {
        this.battery.receiveInternal(this.getPotentialForTick() * (long)i, false);
    }

    public int consumeFE(@NotNull IIOTile slave, int requested, boolean simulate) {
        return super.consumeFE(slave, requested, simulate);
    }

    public StructureMap getStructureList() {
        return EESolar.SL;
    }

    protected abstract TierInfo getTier();

    @NotNull
    public IOMode getFEIOMode() {
        return IOMode.OUT;
    }

    protected long getCellPotential() {
        return (long)((double)this.getCellPotentialPerTick() * this.efficiency);
    }

    private long getPotentialForTick() {
        long pot = 0L;
        long cellPot = this.getCellPotential();
        boolean rain = this.field_145850_b.func_72896_J();
        boolean thunder = this.field_145850_b.func_72911_I();
        float sunBrightness = WorldUtils.getSunBrightness((World)this.field_145850_b, (float)1.0f);
        if (rain || thunder) {
            pot = (long)((float)pot + (float)((long)((float)(cellPot * (long)this.totalValidCells) * sunBrightness)) * (thunder ? 0.1f : 0.28f));
            long addPot = cellPot * (long)this.totalValidCells / 128L;
            addPot = CModifiersModule.PIEZO_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Long.valueOf(addPot));
            addPot = (long)((float)addPot * this.field_145850_b.func_72867_j(1.0f) * (1.0f + this.field_145850_b.func_72819_i(1.0f)));
            pot += addPot;
        } else if (this.field_145850_b.func_72935_r()) {
            pot = (long)((float)pot + (float)(cellPot * (long)this.totalValidCells) * sunBrightness);
        }
        return pot;
    }

    protected void onProcessStart() {
    }

    protected void onProcessComplete() {
    }

    protected int getProcessDuration() {
        return 10;
    }

    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (type == SaveDataType.TO_CLIENT) {
            nbt.func_74768_a("valid_cells", this.totalValidCells);
            nbt.func_74780_a("efficiency", this.efficiency);
        }
        return super.save(nbt, type);
    }

    public void load(CompoundNBT nbt, SaveDataType type) {
        if (type == SaveDataType.FROM_SERVER) {
            if (nbt.func_74764_b("valid_cells")) {
                this.totalValidCells = nbt.func_74762_e("valid_cells");
            }
            if (nbt.func_74764_b("efficiency")) {
                this.efficiency = nbt.func_74769_h("efficiency");
            }
        }
        super.load(nbt, type);
    }

    protected void setValidSolarsAndEfficiency(int valid, float efficiency) {
        this.totalValidCells = valid;
        this.efficiency = efficiency;
        this.func_70296_d();
    }

    protected Collection<BlockPos> getAllCells() {
        return this.getStructure().getLayoutList(EESolar.SOLAR_CELL).getAllRotated(this.field_174879_c, this.getOrientation());
    }

    protected abstract int getScanRate();

    protected abstract float getEfficiencyMaxMultiplier();

    protected abstract long getCellPotentialPerTick();

    protected static class ContinuousSolarScanner
    implements ITick {
        private SolarCCUTile solarCont;
        private Queue<BlockPos> queue = new LinkedList<BlockPos>();
        private World world;
        private int scanRate;
        private int totalValid = 0;
        private float totalEfficiency = 0.0f;

        public ContinuousSolarScanner(SolarCCUTile cont, int scanRate) {
            this.solarCont = cont;
            this.scanRate = scanRate;
            this.world = cont.field_145850_b;
        }

        public void tick() {
            for (int i = 0; i < this.scanRate; ++i) {
                if (!this.checkValid()) continue;
                ++this.totalValid;
            }
        }

        protected boolean checkValid() {
            if (this.queue.isEmpty()) {
                this.startQueue();
                return false;
            }
            BlockPos pos = this.queue.poll();
            if (!this.world.func_226660_f_(pos.func_177972_a(Direction.UP))) {
                return false;
            }
            TileEntity cell = this.world.func_175625_s(pos);
            if (cell instanceof ISolarCellTile) {
                ISolarCellTile cellE = (ISolarCellTile)cell;
                this.totalEfficiency += ((ISolarCellTile)cell).getEfficiencyMultiplier();
            }
            return true;
        }

        public void setScanRate(int scanRate) {
            this.scanRate = scanRate;
        }

        protected void startQueue() {
            this.solarCont.setValidSolarsAndEfficiency(this.totalValid, Math.min(this.totalEfficiency / (float)this.totalValid, this.solarCont.getEfficiencyMaxMultiplier()));
            this.totalEfficiency = 0.0f;
            this.totalValid = 0;
            this.queue.clear();
            this.queue.addAll(this.solarCont.getAllCells());
        }
    }
}

