/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.impl.item;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.item.IEEContainerItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ItemEnergyStorage
extends Item
implements IEEContainerItem {
    public static final String CURRENT = "current";
    protected final int voltage;
    protected final int currentCapacity;
    protected final int currentReceiveMax;
    protected final int currentExtractMax;

    public ItemEnergyStorage(Item.Properties props, int voltage, int currentCapacity) {
        this(props, voltage, currentCapacity, currentCapacity, currentCapacity);
    }

    public ItemEnergyStorage(Item.Properties item$Settings_1, int voltage, int currentCapacity, int transferRate) {
        this(item$Settings_1, voltage, currentCapacity, transferRate, transferRate);
    }

    public ItemEnergyStorage(Item.Properties item$Settings_1, int voltage, int currentCapacity, int currentReceiveMax, int currentExtractMax) {
        super(item$Settings_1);
        this.voltage = voltage;
        this.currentCapacity = currentCapacity;
        this.currentReceiveMax = currentReceiveMax;
        this.currentExtractMax = currentExtractMax;
    }

    @Override
    public Energy extractEnergy(ItemStack item, Energy requested, boolean sim) {
        if (requested == null || requested.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        if (item.func_77978_p() == null || !item.func_77978_p().func_74764_b(CURRENT)) {
            return Energy.ZERO;
        }
        int currentStored = Math.min(item.func_77978_p().func_74762_e(CURRENT), this.getCurrentCapacity(item));
        int currentExtracted = Math.min(currentStored, Math.min(this.currentExtractMax, requested.getCurrent()));
        if (!sim) {
            item.func_77978_p().func_74768_a(CURRENT, currentStored -= currentExtracted);
        }
        return new Energy(this.voltage, currentExtracted);
    }

    @Override
    public Energy getMaxExtract(ItemStack item) {
        return new Energy(this.voltage, this.currentExtractMax);
    }

    @Override
    public int getExtractVoltage(ItemStack item) {
        return this.voltage;
    }

    @Override
    public Energy receiveEnergy(ItemStack item, Energy provided, boolean sim) {
        if (provided == null || provided.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        if (!item.func_77942_o()) {
            item.func_77982_d(new CompoundNBT());
        }
        int currentStored = Math.min(item.func_77978_p().func_74762_e(CURRENT), this.getCurrentCapacity(item));
        int currentProvided = Math.min(this.currentCapacity - currentStored, Math.min(this.currentReceiveMax, provided.getCurrent()));
        if (!sim) {
            item.func_77978_p().func_74768_a(CURRENT, currentStored += currentProvided);
        }
        return new Energy(this.voltage, currentProvided);
    }

    @Override
    public Energy getMaxReceive(ItemStack item) {
        return new Energy(this.voltage, this.currentReceiveMax);
    }

    @Override
    public int getReceiveVoltage(ItemStack item) {
        return this.voltage;
    }

    @Override
    public int getCurrentCapacity(ItemStack item) {
        return this.currentCapacity;
    }

    @Override
    public int getCurrentStored(ItemStack item) {
        if (item.func_77978_p() == null || !item.func_77978_p().func_74764_b(CURRENT)) {
            return 0;
        }
        return Math.min(item.func_77978_p().func_74762_e(CURRENT), this.getCurrentCapacity(item));
    }
}

