/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.api;

public enum VoltageRange {
    ZERO("zero", 0, 0, 0, "enviroenergyapi.voltage.range.zero", 1, 1, 1),
    EXTRA_LOW("extra_low", ZERO, 20, "enviroenergyapi.voltage.range.extralow", 171, 125, 186),
    LOW("low", EXTRA_LOW, 200, "enviroenergyapi.voltage.range.low", 148, 97, 166),
    MEDIUM("medium", LOW, 2000, "enviroenergyapi.voltage.range.medium", 124, 69, 145),
    HIGH("high", MEDIUM, 20000, "enviroenergyapi.voltage.range.high", 105, 47, 126),
    EXTRA_HIGH("extra_high", HIGH, 200000, "enviroenergyapi.voltage.range.extrahigh", 85, 29, 108),
    ULTRA_HIGH("ultra_high", EXTRA_HIGH, 2000000, "enviroenergyapi.voltage.range.ultrahigh", 70, 27, 95),
    EXTREME("extreme", ULTRA_HIGH, 20000000, "enviroenergyapi.voltage.range.extreme", 58, 25, 86),
    QUANTUM("quantum", EXTREME, Integer.MAX_VALUE, "enviroenergyapi.voltage.range.quantum", 44, 22, 73);

    private final String name;
    private final int id;
    private final int minVolts;
    private final int maxVolts;
    private final String unlocName;
    private int r;
    private int g;
    private int b;
    private int mcColor;
    private static final VoltageRange[] ALL;

    private VoltageRange(String name, VoltageRange previous, int maxVolts, String unlocName, int r, int g, int b) {
        this(name, previous.id + 1, previous.maxVolts + 1, maxVolts, unlocName, r, g, b);
    }

    private VoltageRange(String name, int id, int minVolts, int maxVolts, String unlocName, int r, int g, int b) {
        this.name = name;
        this.id = id;
        this.minVolts = minVolts;
        this.maxVolts = maxVolts;
        this.unlocName = unlocName;
        this.setColor(r, g, b);
    }

    protected void setColor(int r, int g, int b) {
        int a = 0;
        this.r = r;
        this.g = g;
        this.b = b;
        this.mcColor = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public int getMinVoltage() {
        return this.minVolts;
    }

    public int getMaxVoltage() {
        return this.maxVolts;
    }

    public String getUnlocalizedName() {
        return this.unlocName;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getMcColor() {
        return this.mcColor;
    }

    public int getMcColor(int alpha) {
        return (alpha & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public boolean isInVoltageRange(int voltage) {
        return voltage <= this.maxVolts && voltage >= this.minVolts;
    }

    public int clamp(int voltage) {
        if (voltage < this.minVolts) {
            return this.minVolts;
        }
        return voltage > this.maxVolts ? this.maxVolts : voltage;
    }

    public static void loadConfiguration() {
    }

    public static VoltageRange fromVoltage(int voltage) {
        for (VoltageRange range : ALL) {
            if (!range.isInVoltageRange(voltage)) continue;
            return range;
        }
        return ZERO;
    }

    public static VoltageRange fromName(String name) {
        for (VoltageRange range : ALL) {
            if (!range.name.equals(name)) continue;
            return range;
        }
        return ZERO;
    }

    static {
        ALL = VoltageRange.values();
    }
}

