/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_solar_distiller.obj;

import com.valkyrieofnight.envirocore.core.tile.machine.ECFacingMachineTile;
import com.valkyrieofnight.envirocore.m_machines.m_solar_distiller.MSolarDistiller;
import com.valkyrieofnight.envirocore.m_machines.m_solar_distiller.datapack.SolarDistillerRecipe;
import com.valkyrieofnight.envirocore.m_machines.m_solar_distiller.ui.SolarDistillerContainer;
import com.valkyrieofnight.vlib.core.obj.block.withtile.VLHorizontalFacingTileBlock;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.integration.forge.fluid.IVLFluidTank;
import com.valkyrieofnight.vlib.integration.forge.fluid.VLFluidTankPrecise;
import com.valkyrieofnight.vlib.integration.forge.fluid.tile.FluidIOHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SolarDistillerTile
extends ECFacingMachineTile
implements IProvideGui<SolarDistillerContainer> {
    protected VLInventory fluidIn = new VLInventory(new IOMode[]{IOMode.IN, IOMode.OUT});
    protected VLInventory fluidOut = new VLInventory(new IOMode[]{IOMode.IN, IOMode.OUT});
    protected VLFluidTankPrecise tankIn;
    protected VLFluidTankPrecise tankOut;
    protected FluidIOHandler handlerIn;
    protected FluidIOHandler handlerOut;
    protected VLInventory biproductOut = new VLInventory(new IOMode[]{IOMode.OUT});
    protected SolarDistillerRecipe currentRecipe;
    protected int biProductProgress = 0;
    protected TrackerModule tracker;

    public SolarDistillerContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        if (tileEntity instanceof SolarDistillerTile) {
            return new SolarDistillerContainer(i, playerEntity.field_71071_by, (SolarDistillerTile)tileEntity);
        }
        return null;
    }

    public SolarDistillerTile() {
        super(MSolarDistiller.TILE_TYPE);
        this.tankIn = new VLFluidTankPrecise(6000);
        this.tankOut = new VLFluidTankPrecise(2000);
        this.handlerIn = new FluidIOHandler((IInventory)this.fluidIn, EnumIO.INPUT, (IVLFluidTank)this.tankIn, () -> ((SolarDistillerTile)this).func_70296_d());
        this.handlerOut = new FluidIOHandler((IInventory)this.fluidOut, EnumIO.OUTPUT, (IVLFluidTank)this.tankOut, () -> ((SolarDistillerTile)this).func_70296_d());
        this.setupInventory(new IVLSerializableInventory[]{this.fluidIn, this.fluidOut, this.biproductOut});
        this.setupMainModule(ModuleBuilders.noAcceleration().addModule((IModuleBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).canStartProcess(this::canStartProcess)).checkAndValidateProcessable(this::checkAndValidateProcessable)).canCompleteProcess(() -> this.tankOut.getFluidAmount() < this.tankOut.getCapacity())).onProcessTick(i -> this.biProductProgress += i.intValue())).onComplete(this::onCompleteProcess)).maxTickRate(() -> 1)).processDuration(() -> 1)).serverTick(this::serverTick)));
    }

    protected void resetTracker() {
        this.tracker.reset();
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    protected void serverTick() {
        this.handlerIn.tick();
        this.handlerOut.tick();
    }

    public IVLFluidTank getTank(EnumIO io) {
        return io == EnumIO.INPUT ? this.tankIn : this.tankOut;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        nbt.func_218657_a("tank_in", (INBT)this.tankIn.serializeNBT());
        nbt.func_218657_a("tank_out", (INBT)this.tankOut.serializeNBT());
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("tank_in")) {
            this.tankIn.deserializeNBT(nbt.func_74775_l("tank_in"));
        }
        if (nbt.func_74764_b("tank_out")) {
            this.tankOut.deserializeNBT(nbt.func_74775_l("tank_out"));
        }
        super.load(nbt, type);
    }

    protected boolean canStartProcess() {
        if (this.currentRecipe != null && this.currentRecipe.getInput(this.conditionProvider).func_207187_a(this.tankIn.getFluid().getFluid())) {
            return this.tankOut.getRemainingLevel() >= (double)this.currentRecipe.getConversionRate(this.conditionProvider);
        }
        if (this.tankIn.getFluid().getFluid() != Fluids.field_204541_a) {
            this.biProductProgress = 0;
            this.currentRecipe = null;
            this.currentRecipe = MSolarDistiller.RECIPE_REGISTRY.getRecipe(this.conditionProvider, this.tankIn.getFluid().getFluid());
            if (this.currentRecipe != null) {
                return this.tankOut.getRemainingLevel() >= (double)this.currentRecipe.getConversionRate(this.conditionProvider);
            }
        }
        return false;
    }

    protected int checkAndValidateProcessable(int i) {
        if (this.currentRecipe == null) {
            this.resetTracker();
            return 0;
        }
        double stuff = this.currentRecipe.getConversionRate(this.conditionProvider);
        if (this.func_145831_w().func_72935_r() && this.tankOut.getRemainingLevel() >= stuff && this.tankIn.getLevel() >= stuff) {
            return i;
        }
        return 0;
    }

    protected void onCompleteProcess() {
        if (this.tankOut.getFluidAmount() < this.tankOut.getCapacity() && this.currentRecipe != null) {
            int dur;
            Fluid input = this.currentRecipe.getInput(this.conditionProvider);
            Fluid output = this.currentRecipe.getOutput(this.conditionProvider);
            double amount = this.currentRecipe.getConversionRate(this.conditionProvider);
            this.tankIn.drain(input, amount, IFluidHandler.FluidAction.EXECUTE);
            this.tankOut.fill(output, amount, IFluidHandler.FluidAction.EXECUTE);
            if (this.currentRecipe.hasBiProduct() && this.biProductProgress >= (dur = this.currentRecipe.getBiProductDuration(this.conditionProvider).intValue())) {
                ItemStack bp = this.currentRecipe.getBiProduct(this.conditionProvider);
                this.biProductProgress = 0;
                InventoryUtils.insertItem((IInventory)this.biproductOut, (int)0, (ItemStack)bp, (boolean)false);
            }
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.envirocore.solar_distiller");
    }

    @Override
    public Direction getFacing() {
        return (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)VLHorizontalFacingTileBlock.FACING);
    }
}

