/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipe;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipeRegistry;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.value.RawValueProvider;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class AbstractCatListRecipeDeserializer<RECIPE extends AbstractCatListRecipe, REGISTRY extends AbstractCatListRecipeRegistry<RECIPE>>
extends VLRecipeSerializer<RECIPE, REGISTRY> {
    public AbstractCatListRecipeDeserializer(REGISTRY registry) {
        super(registry);
    }

    public RECIPE deserializeRecipe(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo;
        if (json.isJsonObject() && (jo = (JsonObject)json).has("input") && jo.has("output") && this.hasOtherRequired(jo)) {
            Ingredient in = DeserializerUtils.getRawItemIngredient((JsonObject)JsonUtils.getAsJsonObject((JsonObject)jo, (String)"input"), (JsonDeserializationContext)context);
            Ingredient out = DeserializerUtils.getRawItemIngredient((JsonObject)JsonUtils.getAsJsonObject((JsonObject)jo, (String)"output"), (JsonDeserializationContext)context);
            int r = MathUtil.clamp((int)JsonUtils.getAsIntOrDefault((JsonObject)jo, (String)"r", (int)0), (int)0, (int)255);
            int g = MathUtil.clamp((int)JsonUtils.getAsIntOrDefault((JsonObject)jo, (String)"g", (int)0), (int)0, (int)255);
            int b = MathUtil.clamp((int)JsonUtils.getAsIntOrDefault((JsonObject)jo, (String)"b", (int)0), (int)0, (int)255);
            ArrayList categories = Lists.newArrayList();
            JsonArray ja = JsonUtils.getAsArray((JsonObject)jo, (String)"categories");
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    String id = JsonUtils.getAsString((JsonElement)ja.get(i));
                    if (StringUtils.isNullOrEmpty((CharSequence)id)) continue;
                    categories.add(VLID.from((String)id));
                }
            }
            Provider dur = DeserializerUtils.getProvider((JsonObject)jo, (String)"duration", (String)"int", (JsonDeserializationContext)context);
            if (in != null && out != null) {
                return this.createRecipe(jo, context, categories, new Color4(r, g, b), (Ingredient<ItemStack>)in, (Ingredient<ItemStack>)out, (Provider<Integer>)(dur != null ? dur : new RawValueProvider.Int(Integer.valueOf(100))));
            }
        }
        return null;
    }

    protected void handleException(VLID vlid, Exception e) {
    }

    protected abstract boolean hasOtherRequired(@Nonnull JsonObject var1);

    @Nullable
    protected abstract RECIPE createRecipe(@Nonnull JsonObject var1, @Nonnull JsonDeserializationContext var2, @Nonnull List<VLID> var3, Color4 var4, @Nonnull Ingredient<ItemStack> var5, @Nonnull Ingredient<ItemStack> var6, @Nonnull Provider<Integer> var7);
}

