/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.util.text.Style;
import net.minecraftforge.common.ToolType;

public class TierInfo {
    private static List<TierInfo> registered = Lists.newArrayList();
    private final String name;
    private final int tier;
    private final Color4 color;
    private final Color4 structureDefaultColor;
    private final float hardness;
    private final float resistance;
    private final Material material;
    private final ToolType harvestTool;
    private final int harvestLevel;
    private final Style style;
    private final boolean glint;
    public static final TierInfo LITHERITE = new TierInfo("litherite", Material.field_151573_f, 1, new Color4(9, 135, 80), new Color4(255, 255, 255), 2.0f, 10.0f, ToolType.PICKAXE, 1, false);
    public static final TierInfo ERODIUM = new TierInfo("erodium", Material.field_151573_f, 2, new Color4(125, 102, 159), new Color4(247, 247, 247), 2.0f, 100.0f, ToolType.PICKAXE, 1, false);
    public static final TierInfo KYRONITE = new TierInfo("kyronite", Material.field_151573_f, 3, new Color4(91, 32, 82), new Color4(239, 239, 239), 3.0f, 1000.0f, ToolType.PICKAXE, 1, false);
    public static final TierInfo PLADIUM = new TierInfo("pladium", Material.field_151573_f, 4, new Color4(42, 64, 128), new Color4(231, 231, 231), 3.0f, 10000.0f, ToolType.PICKAXE, 1, false);
    public static final TierInfo IONITE = new TierInfo("ionite", Material.field_151574_g, 5, new Color4(66, 199, 255), new Color4(223, 223, 223), 4.0f, 100000.0f, ToolType.PICKAXE, 1, false);
    public static final TierInfo AETHIUM = new TierInfo("aethium", Material.field_151574_g, 6, new Color4(21, 21, 21), new Color4(215, 215, 215), 4.0f, 1000000.0f, ToolType.PICKAXE, 1, false, Style.field_240709_b_.func_240718_a_(new Color4(40, 40, 40).getMCColor()));
    public static final TierInfo NANORITE = new TierInfo("nanorite", Material.field_151574_g, 7, new Color4(119, 54, 150), new Color4(207, 207, 207), 5.0f, 1.0E7f, ToolType.PICKAXE, 1, true);
    public static final TierInfo XEROTHIUM = new TierInfo("xerothium", Material.field_151574_g, 8, new Color4(127, 238, 255), new Color4(199, 199, 199), 5.0f, 1.0E8f, ToolType.PICKAXE, 1, true);

    private static void reg(@NotNull TierInfo ti) {
        TierInfo tier = TierInfo.getByName(ti.getName());
        if (tier != null) {
            return;
        }
        registered.add(ti);
    }

    public static TierInfo getByName(@NotNull String name) {
        for (TierInfo ti : registered) {
            if (!ti.name.equals(name)) continue;
            return ti;
        }
        return null;
    }

    public static TierInfo getByTier(int tier) {
        for (TierInfo ti : registered) {
            if (ti.tier != tier) continue;
            return ti;
        }
        return null;
    }

    public TierInfo(String name, Material material, int tier, Color4 color, Color4 structureColor, float hardness, float resistance, ToolType harvestTool, int harvestLevel, boolean glint) {
        this.name = name;
        this.material = material;
        this.tier = tier;
        this.color = color;
        this.structureDefaultColor = structureColor;
        this.hardness = hardness;
        this.resistance = resistance;
        this.harvestTool = harvestTool;
        this.harvestLevel = harvestLevel;
        this.glint = glint;
        this.style = Style.field_240709_b_.func_240718_a_(color.getMCColor());
        TierInfo.reg(this);
    }

    public TierInfo(String name, Material material, int tier, Color4 color, Color4 structureColor, float hardness, float resistance, ToolType harvestTool, int harvestLevel, boolean glint, Style override) {
        this.name = name;
        this.material = material;
        this.tier = tier;
        this.color = color;
        this.structureDefaultColor = structureColor;
        this.hardness = hardness;
        this.resistance = resistance;
        this.harvestTool = harvestTool;
        this.harvestLevel = harvestLevel;
        this.glint = glint;
        this.style = override;
        TierInfo.reg(this);
    }

    public String getName() {
        return this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getTier() {
        return this.tier;
    }

    public Color4 getColor() {
        return this.color;
    }

    public Color4 getStructureColor() {
        return this.structureDefaultColor;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public String getUnlocalized() {
        return "tier.envirocore." + this.name;
    }

    public ToolType getHarvestTool() {
        return this.harvestTool;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public Style getNameStyle() {
        return this.style;
    }

    public String toString() {
        return "{tier:" + this.name + "}";
    }
}

