/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.util;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.util.AbstractEnergyConverter;

public abstract class NumberEnergyConverter<TYPE extends Number>
extends AbstractEnergyConverter<TYPE> {
    public NumberEnergyConverter(int nativeVoltage) {
        super(nativeVoltage);
    }

    @Override
    public Energy convert(TYPE energyIn) {
        return new Energy(this.nativeVoltage, ((Number)energyIn).intValue());
    }

    @Override
    public long convertToPotential(TYPE energyIn) {
        long input = Math.max(0L, Math.min(((Number)energyIn).longValue(), Integer.MAX_VALUE));
        return (long)this.nativeVoltage * input;
    }

    @Override
    public long getMaximumConvertable(long potential) {
        return potential - this.getConvertibleRemainder(potential);
    }

    @Override
    public long getConvertibleRemainder(long potential) {
        return potential % (long)this.nativeVoltage;
    }
}

