/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.ui.client;

import com.google.common.base.Predicate;
import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.TRGBController;
import com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.net.PacketSetColors;
import com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.ui.RGBControllerContainer;
import com.valkyrieofnight.vlib.core.network.VLPacket;
import com.valkyrieofnight.vlib.core.ui.client.VLContainerScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.scroll.ScrollBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action2a;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RGBControllerGUI
extends VLContainerScreen<RGBControllerContainer> {
    protected Predicate<String> colorValidator = str -> {
        if (!Pattern.matches("^[0-9]*$", str)) {
            return false;
        }
        return !StringUtils.isNullOrEmpty((CharSequence)str);
    };
    protected BiFunction<String, Integer, String> colorChanger = (str, i) -> {
        if (!Pattern.matches("^[0-9]*$", str)) {
            return "";
        }
        if (StringUtils.isNullOrEmpty((CharSequence)str)) {
            return "";
        }
        int n = Integer.parseInt(str);
        n = MathUtil.clamp((int)n, (int)0, (int)255);
        str = "" + n;
        return "" + n;
    };
    private Color4 defaultPrimary = Color4.WHITE;
    private Color4 defaultSecondary = Color4.WHITE;
    protected LabelElement chan1Title;
    protected LabelElement chan2Title;
    protected SizablePanelElement colorBar1;
    protected SizablePanelElement colorBar2;
    protected ScrollColor rs;
    protected ScrollColor gs;
    protected ScrollColor bs;
    protected Color4 r = Color4.WHITE;
    protected Color4 g = Color4.WHITE;
    protected Color4 b = Color4.WHITE;
    protected ScrollColor rs2;
    protected ScrollColor gs2;
    protected ScrollColor bs2;
    protected Color4 r2 = Color4.WHITE;
    protected Color4 g2 = Color4.WHITE;
    protected Color4 b2 = Color4.WHITE;
    protected ScrollBarElement lightLevelBar;
    protected SizablePanelElement lightLevelBG;
    private int lightLevel = 0;
    private int lightPosition = 0;
    protected LabelElement lightLevelText;

    public RGBControllerGUI(RGBControllerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 264;
        this.field_147000_g = 130;
        this.rs = new ScrollColor("r", (Action2a<Float, SizablePanelElement>)((Action2a)this::setR), (ITextComponent)new TranslationTextComponent("label.valkyrielib.red"));
        this.gs = new ScrollColor("g", (Action2a<Float, SizablePanelElement>)((Action2a)this::setG), (ITextComponent)new TranslationTextComponent("label.valkyrielib.green"));
        this.bs = new ScrollColor("b", (Action2a<Float, SizablePanelElement>)((Action2a)this::setB), (ITextComponent)new TranslationTextComponent("label.valkyrielib.blue"));
        this.rs2 = new ScrollColor("r2", (Action2a<Float, SizablePanelElement>)((Action2a)this::setR2), (ITextComponent)new TranslationTextComponent("label.valkyrielib.red"));
        this.gs2 = new ScrollColor("g2", (Action2a<Float, SizablePanelElement>)((Action2a)this::setG2), (ITextComponent)new TranslationTextComponent("label.valkyrielib.green"));
        this.bs2 = new ScrollColor("b2", (Action2a<Float, SizablePanelElement>)((Action2a)this::setB2), (ITextComponent)new TranslationTextComponent("label.valkyrielib.blue"));
        for (ItemStack item : playerInventory.field_70458_d.func_184214_aD()) {
            if (!item.func_77973_b().equals((Object)TRGBController.ITEM)) continue;
            this.defaultPrimary = new Color4(TRGBController.ITEM.getPrimaryColor(item));
            this.defaultSecondary = new Color4(TRGBController.ITEM.getSecondaryColor(item));
            this.r = new Color4(this.defaultPrimary.getR(), 0.0f, 0.0f, 1.0f);
            this.rs.setColor(this.r, this.defaultPrimary.getRi());
            this.g = new Color4(0.0f, this.defaultPrimary.getG(), 0.0f, 1.0f);
            this.gs.setColor(this.g, this.defaultPrimary.getGi());
            this.b = new Color4(0.0f, 0.0f, this.defaultPrimary.getB(), 1.0f);
            this.bs.setColor(this.b, this.defaultPrimary.getBi());
            this.rs.setPosition((int)(256.0f * this.defaultPrimary.getR()));
            this.gs.setPosition((int)(256.0f * this.defaultPrimary.getG()));
            this.bs.setPosition((int)(256.0f * this.defaultPrimary.getB()));
            this.r2 = new Color4(this.defaultSecondary.getR(), 0.0f, 0.0f, 1.0f);
            this.rs2.setColor(this.r2, this.defaultSecondary.getRi());
            this.g2 = new Color4(0.0f, this.defaultSecondary.getG(), 0.0f, 1.0f);
            this.gs2.setColor(this.g2, this.defaultSecondary.getGi());
            this.b2 = new Color4(0.0f, 0.0f, this.defaultSecondary.getB(), 1.0f);
            this.bs2.setColor(this.b2, this.defaultSecondary.getBi());
            this.rs2.setPosition((int)(256.0f * this.defaultSecondary.getR()));
            this.gs2.setPosition((int)(256.0f * this.defaultSecondary.getG()));
            this.bs2.setPosition((int)(256.0f * this.defaultSecondary.getB()));
            this.lightLevel = TRGBController.ITEM.getLightLevel(item);
            break;
        }
    }

    private void setR(Float r, SizablePanelElement bg) {
        this.r = new Color4(r.floatValue(), 0.0f, 0.0f, 1.0f);
        bg.setColor(this.r);
        this.calcDefaultPrimary();
    }

    private void setG(Float g, SizablePanelElement bg) {
        this.g = new Color4(0.0f, g.floatValue(), 0.0f, 1.0f);
        bg.setColor(this.g);
        this.calcDefaultPrimary();
    }

    private void setB(Float b, SizablePanelElement bg) {
        this.b = new Color4(0.0f, 0.0f, b.floatValue(), 1.0f);
        bg.setColor(this.b);
        this.calcDefaultPrimary();
    }

    private void setR2(Float r, SizablePanelElement bg) {
        this.r2 = new Color4(r.floatValue(), 0.0f, 0.0f, 1.0f);
        bg.setColor(this.r2);
        this.calcDefaultSecondary();
    }

    private void setG2(Float g, SizablePanelElement bg) {
        this.g2 = new Color4(0.0f, g.floatValue(), 0.0f, 1.0f);
        bg.setColor(this.g2);
        this.calcDefaultSecondary();
    }

    private void setB2(Float b, SizablePanelElement bg) {
        this.b2 = new Color4(0.0f, 0.0f, b.floatValue(), 1.0f);
        bg.setColor(this.b2);
        this.calcDefaultSecondary();
    }

    protected void addElements() {
        int middle = this.field_146999_f / 2;
        int rgbBoxWidth = 28;
        int rgbBoxWidthHalf = rgbBoxWidth / 2;
        int rgbBoxHeight = 8;
        int innerLeft = 8;
        int innerRight = this.field_146999_f - innerLeft;
        int yPos = 4;
        this.addElement((IElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_INNER_BG), 0, 0);
        LabelElement title = new LabelElement("title", (ITextComponent)new TranslationTextComponent("item.envirocore.rgb_controller"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        title.setHorizontalAlignment(HAlignment.CENTER);
        this.addElement((IElement)title, this.field_146999_f / 2, yPos);
        this.chan1Title = new LabelElement("c1t", (ITextComponent)new TranslationTextComponent("label.envirocore.channel1"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)this.chan1Title, 4, yPos += 11);
        this.addElement((IElement)this.rs, 3, yPos += 10);
        this.addElement((IElement)this.gs, 3, yPos += 10);
        this.addElement((IElement)this.bs, 3, yPos += 10);
        this.colorBar1 = new SizablePanelElement("cbg", StandardThemeAssets.GSB_VANILLA_TOAST_LIGHT_SQUARE_BG, 258, 10);
        this.addElement((IElement)this.colorBar1, 3, yPos += 10);
        this.colorBar1.setColor(this.defaultPrimary);
        this.lightLevelBG = new SizablePanelElement("llb", StandardThemeAssets.GSB_VANILLA_CREATIVE_TEXTFIELD, this.getLightLevelScrollLength() + 2, 10);
        this.addElement((IElement)this.lightLevelBG, 3, yPos += 10);
        this.lightLevelBar = new ScrollBarElement("ll", 5, 8, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_5X8_H_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_5X8_H_DIS, Alignment.HORIZONTAL, this::getLightLevelScrollLength, this::getLightLevelScrollDistance, this::getLightLevelScrollPosition, this::getLightLevelStepAmount, this::onLightLevelScroll);
        this.addElement((IElement)this.lightLevelBar, 4, ++yPos);
        this.lightLevelText = new LabelElement("llt", (ITextComponent)new StringTextComponent("" + this.lightLevel), Color4.WHITE);
        this.addElement((IElement)this.lightLevelText, 6, ++yPos);
        this.field_147000_g = yPos + 12;
    }

    private void calcDefaultPrimary() {
        this.defaultPrimary = new Color4(this.r.getR(), this.g.getG(), this.b.getB(), 1.0f);
        this.colorBar1.setColor(this.defaultPrimary);
    }

    private void calcDefaultSecondary() {
        this.defaultSecondary = new Color4(this.r2.getR(), this.g2.getG(), this.b2.getB(), 1.0f);
        this.colorBar2.setColor(this.defaultSecondary);
    }

    private int getLightLevelStepAmount() {
        return 1;
    }

    private int getLightLevelScrollLength() {
        return 64;
    }

    private int getLightLevelScrollDistance() {
        return 15;
    }

    private int getLightLevelScrollPosition() {
        return this.lightLevel * this.getLightLevelStepAmount();
    }

    private void onLightLevelScroll(Float aFloat) {
        this.lightLevel = (int)(15.0f * aFloat.floatValue());
    }

    public void update() {
        super.update();
        this.lightLevelText.setText((ITextComponent)new StringTextComponent("" + this.lightLevel));
    }

    protected void onCloseKeysPressed() {
        Color4 primary = new Color4(this.r.getR(), this.g.getG(), this.b.getB(), 1.0f);
        Color4 sec = new Color4(this.r2.getR(), this.g2.getG(), this.b2.getB(), 1.0f);
        EnviroCore.NETWORK_HANDLER.sendToServer((VLPacket)new PacketSetColors(primary, sec, MathUtil.clamp((int)this.lightLevel, (int)0, (int)15)));
        super.onCloseKeysPressed();
    }

    public static class ScrollColor
    extends FixedContainerElement {
        protected ScrollBarElement bar;
        protected SizablePanelElement bg;
        protected LabelElement label;
        protected LabelElement value;
        protected int position = 0;
        protected Action2a<Float, SizablePanelElement> setColor;

        public ScrollColor(String id, Action2a<Float, SizablePanelElement> setColor, ITextComponent title) {
            super(id, 258, 10);
            this.setColor = setColor;
            this.label = new LabelElement("title", title, Color4.WHITE);
            this.bg = new SizablePanelElement("rbg", StandardThemeAssets.GSB_VANILLA_CREATIVE_TEXTFIELD, this.getScrollLength() + 2, 10);
            this.bar = new ScrollBarElement("r", 5, 8, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_5X8_H_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_5X8_H_DIS, Alignment.HORIZONTAL, this::getScrollLength, this::getScrollDistance, this::getScrollPosition, this::getStepAmount, this::onScroll);
            this.value = new LabelElement("v", (ITextComponent)new StringTextComponent(""), Color4.WHITE);
        }

        public void addElements() {
            this.addElement((IElement)this.bg, 0, 0);
            this.addElement((IElement)this.label, 129, 5);
            this.label.setVerticalAlignment(VAlignment.CENTER);
            this.label.setHorizontalAlignment(HAlignment.CENTER);
            this.addElement((IElement)this.bar, 1, 1);
            this.addElement((IElement)this.value, 4, 1);
        }

        private int getStepAmount() {
            return 1;
        }

        private int getScrollLength() {
            return 256;
        }

        private int getScrollDistance() {
            return 256;
        }

        private int getScrollPosition() {
            return this.position;
        }

        private void onScroll(float m) {
            this.position = (int)((float)this.getScrollLength() * m);
            this.setColor.execute((Object)Float.valueOf(m), (Object)this.bg);
            this.value.setText((ITextComponent)new StringTextComponent("" + (int)(255.0f * m)));
        }

        public void setColor(Color4 col, int value) {
            this.bg.setColor(col);
            this.value.setText((ITextComponent)new StringTextComponent("" + value));
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public void update() {
            super.update();
        }
    }
}

