/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_crusher.obj;

import com.valkyrieofnight.envirocore.core.tile.machine.ECEnergyReceiverTile;
import com.valkyrieofnight.envirocore.m_machines.m_crusher.MCrusher;
import com.valkyrieofnight.envirocore.m_machines.m_crusher.datapack.CrusherRecipe;
import com.valkyrieofnight.envirocore.m_machines.m_crusher.ui.CrusherContainer;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.VoltageRange;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CrusherTile
extends ECEnergyReceiverTile
implements IProvideGui<CrusherContainer> {
    protected static int POTENTIAL_PER_TICK = 1000;
    protected static int VOLTAGE = VoltageRange.EXTRA_LOW.getMaxVoltage();
    protected VLInventory input = new VLInventory(new IOMode[]{IOMode.IN});
    protected VLInventory output = new VLInventory(new IOMode[]{IOMode.OUT});
    protected CrusherRecipe recipe;
    protected TrackerModule tracker;

    public CrusherContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        if (tileEntity instanceof CrusherTile) {
            return new CrusherContainer(i, playerEntity.field_71071_by, (CrusherTile)tileEntity);
        }
        return null;
    }

    public CrusherTile() {
        super(MCrusher.TILE_TYPE, VOLTAGE, VOLTAGE * 1000);
        this.setupInventory(new RelativeDirection[0], new IVLSerializableInventory[]{this.input, this.output});
        this.setupMainModule(ModuleBuilders.noAcceleration().addModule((IModuleBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).canStartProcess(this::canStartProcess)).checkAndValidateProcessable(this::checkAndValidateProcessable)).canCompleteProcess(this::canCompleteProcess)).onProcessTick(this::onProcessTicks)).onComplete(this::onCompleteProcess)).maxTickRate(() -> 1)).processDuration(() -> this.recipe != null ? this.recipe.getDuration(this.conditionProvider) : 100)));
    }

    protected void resetTracker() {
        this.tracker.reset();
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    protected boolean canStartProcess() {
        if (this.recipe == null || !this.recipe.testInput(this.conditionProvider, this.input.func_70301_a(0))) {
            this.recipe = MCrusher.RECIPE_REGISTRY.getRecipe(this.conditionProvider, this.input.func_70301_a(0));
        }
        if (this.recipe != null) {
            return this.isRecipeInputValid() && InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)this.recipe.getOutput(this.conditionProvider));
        }
        return false;
    }

    private boolean isRecipeInputValid() {
        int costCount = this.recipe.getInputCount(this.conditionProvider);
        return this.recipe.testInput(this.conditionProvider, this.input.func_70301_a(0)) && InventoryUtils.canExtract((IInventory)this.input, (int)0, (int)costCount);
    }

    protected int checkAndValidateProcessable(int i) {
        if (this.recipe == null || !this.recipe.testInput(this.conditionProvider, this.input.func_70301_a(0))) {
            this.resetTracker();
        }
        if (this.energyStorage.getPotentialStored() >= (long)(POTENTIAL_PER_TICK * i)) {
            return i;
        }
        return 0;
    }

    protected void onProcessTicks(int i) {
        if (this.recipe == null) {
            this.resetTracker();
        } else {
            this.energyStorage.extractEnergy(Energy.fromPotential(this.voltage, POTENTIAL_PER_TICK * i), false);
        }
        this.func_70296_d();
    }

    protected boolean canCompleteProcess() {
        if (this.recipe == null || !this.isRecipeInputValid()) {
            this.resetTracker();
            return false;
        }
        if (this.output.func_70301_a(0).equals(ItemStack.field_190927_a)) {
            return true;
        }
        ItemStack o = this.recipe.getOutput(this.conditionProvider);
        return InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)o);
    }

    protected void onCompleteProcess() {
        ItemStack o = this.recipe.getOutput(this.conditionProvider);
        InventoryUtils.extractItem((IInventory)this.input, (int)0, (int)this.recipe.getInputCount(this.conditionProvider), (boolean)false);
        InventoryUtils.insertItem((IInventory)this.output, (int)0, (ItemStack)o, (boolean)false);
    }
}

