/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_assembler.ui;

import com.google.common.collect.Lists;
import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.m_machines.ECMachinesModule;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.MAssembler;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.net.SetStackSizePacket;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.obj.AssemblerTile;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.ui.AssemblerContainer;
import com.valkyrieofnight.vlib.core.network.VLPacket;
import com.valkyrieofnight.vlib.core.ui.client.VLTileInventoryScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.SequenceButton;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.guage.ImageProgressBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.inventory.SlotsArrayElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.container.VLContainer;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AssemblerGui
extends VLTileInventoryScreen<AssemblerTile, AssemblerContainer> {
    private AssemblerTile tile;
    private ImageProgressBarElement energyGuage;
    private QuickTooltips.Map energyGuageTooltips = QuickTooltips.createMap();
    private ImageProgressBarElement progress;
    private QuickTooltips.Map progressTooltips = QuickTooltips.createMap();
    private SequenceButton stackSizeButton;

    public AssemblerGui(AssemblerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((VLContainer)container, playerInventory, title);
        this.field_230711_n_ = false;
        this.setGuiSize(176, 200);
        this.tile = (AssemblerTile)container.getTile();
    }

    protected void addElements() {
        LabelElement title = new LabelElement("title", this.tile.func_145748_c_(), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        title.setHorizontalAlignment(HAlignment.CENTER);
        this.addElement((IElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_CONTAINER), 0, 0);
        this.addElement((IElement)title, this.field_146999_f / 2, 6);
        this.addElement((IElement)new ImageElement("gbg", MAssembler.BACKGROUND), 8, 16);
        this.energyGuage = new ImageProgressBarElement("energy", ECMachinesModule.ENERGY_BAR_08X48, ProgressionDirection.UPWARD, this::getEnergy);
        this.addElement((IElement)this.energyGuage, 12, 20);
        this.energyGuage.setToolTips((ITooltipBuilder)this.energyGuageTooltips);
        SlotsArrayElement sae = new SlotsArrayElement("slots", this.field_147002_h, StandardThemeAssets.TEX_VANILLA_SLOT);
        this.addElement((IElement)sae, 0, 0);
        LabelElement inv = new LabelElement("inventory", this.field_213127_e.func_145748_c_(), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)inv, 8, this.field_147000_g - 96 + 3);
        this.energyGuageTooltips.set(0, (ITextComponent)new TranslationTextComponent("label.envirocore.energy.storage").func_230530_a_(StyleUtil.create((Color4)Color4.AZURE)));
        this.addElement((IElement)new SizablePanelElement("progress_bg", ECMachinesModule.GSB_DARK_INNER_PANEL, 36, 8), 94, 46);
        this.progress = new ImageProgressBarElement("progress", MAssembler.PROGRESS, ProgressionDirection.TO_RIGHT, this::getProgress);
        this.addElement((IElement)this.progress, 95, 47);
        this.progress.setToolTips((ITooltipBuilder)this.progressTooltips);
        this.stackSizeButton = new SequenceButton("stack_size", 8, 8, 4, 4, new AssetID[]{ECMachinesModule.TEX_MODE_SINGLE, ECMachinesModule.TEX_MODE_STACK}){

            public void addElements() {
                this.addElementAllStates((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA), 0, 0);
            }
        };
        this.addElement((IElement)this.stackSizeButton, 12, 72);
        this.stackSizeButton.setToolTipList((List)Lists.newArrayList((Object[])new ITextComponent[]{TextComponentUtil.create((IFormattableTextComponent[])new IFormattableTextComponent[]{new TranslationTextComponent("label.envirocore.stacksize")})}));
    }

    public void update() {
        super.update();
        if (this.tile.getStackSize() == 64) {
            this.stackSizeButton.setIndex(1);
        }
        if (this.stackSizeButton.getIndex() == 0) {
            this.stackSizeButton.setToolTipList((List)Lists.newArrayList((Object[])new ITextComponent[]{TextComponentUtil.create((IFormattableTextComponent[])new IFormattableTextComponent[]{new TranslationTextComponent("label.envirocore.stacksize").func_230530_a_(StyleUtil.create((Color4)Color4.AZURE)).func_230529_a_((ITextComponent)new StringTextComponent(": 1"))})}));
        } else {
            this.stackSizeButton.setToolTipList((List)Lists.newArrayList((Object[])new ITextComponent[]{TextComponentUtil.create((IFormattableTextComponent[])new IFormattableTextComponent[]{new TranslationTextComponent("label.envirocore.stacksize").func_230530_a_(StyleUtil.create((Color4)Color4.AZURE)).func_230529_a_((ITextComponent)new StringTextComponent(": 64"))})}));
        }
        this.energyGuageTooltips.set(1, (ITextComponent)new TranslationTextComponent("label.envirocore.capacity").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", this.tile.getFECapacity()))));
        this.energyGuageTooltips.set(2, (ITextComponent)new TranslationTextComponent("label.envirocore.stored").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", this.tile.getFEStored()))));
    }

    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        if (this.stackSizeButton.equals(element)) {
            SetStackSizePacket packet = new SetStackSizePacket(this.tile.func_174877_v(), this.stackSizeButton.getIndex() == 0 ? 1 : 64);
            EnviroCore.NETWORK_HANDLER.sendToServer((VLPacket)packet);
        }
    }

    private float getEnergy() {
        return this.tile.getEnergyScaled();
    }

    private float getProgress() {
        return this.tile.getProgressScale();
    }
}

