/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_assembler.datapack;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class AssemblerRecipe
extends VLRecipe {
    protected Provider<Integer> duration;
    protected Ingredient<ItemStack> top;
    protected Ingredient<ItemStack> bot;
    protected Ingredient<ItemStack> lef;
    protected Ingredient<ItemStack> rig;
    protected Ingredient<ItemStack> center;
    protected Ingredient<ItemStack> output;
    protected boolean mergeNBT;

    public AssemblerRecipe(Ingredient<ItemStack> t, Ingredient<ItemStack> b, Ingredient<ItemStack> l, Ingredient<ItemStack> r, Ingredient<ItemStack> c, Ingredient<ItemStack> output, Provider<Integer> duration, boolean mergeNBT) {
        this.top = t;
        this.bot = b;
        this.lef = l;
        this.rig = r;
        this.center = c;
        this.output = output;
        this.duration = duration;
        this.mergeNBT = mergeNBT;
    }

    public AssemblerRecipe(PacketBuffer buffer) {
        super(buffer);
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(this.top != null);
        if (this.top != null) {
            this.top.writePacketData(packetBuffer);
        }
        packetBuffer.writeBoolean(this.bot != null);
        if (this.bot != null) {
            this.bot.writePacketData(packetBuffer);
        }
        packetBuffer.writeBoolean(this.lef != null);
        if (this.lef != null) {
            this.lef.writePacketData(packetBuffer);
        }
        packetBuffer.writeBoolean(this.rig != null);
        if (this.rig != null) {
            this.rig.writePacketData(packetBuffer);
        }
        this.center.writePacketData(packetBuffer);
        this.output.writePacketData(packetBuffer);
        this.duration.writePacketData(packetBuffer);
        packetBuffer.writeBoolean(this.mergeNBT);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        if (packetBuffer.readBoolean()) {
            this.top = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        }
        if (packetBuffer.readBoolean()) {
            this.bot = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        }
        if (packetBuffer.readBoolean()) {
            this.lef = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        }
        if (packetBuffer.readBoolean()) {
            this.rig = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        }
        this.center = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.output = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.duration = DeserializerUtils.readProviderFromPacket((PacketBuffer)packetBuffer);
        this.mergeNBT = packetBuffer.readBoolean();
    }

    protected boolean canWriteData() {
        return this.center != null && this.output != null && this.duration != null;
    }

    public boolean testPopulatedInputs(ConditionContainerProvider ccp, ItemStack top, ItemStack bot, ItemStack lef, ItemStack rig, ItemStack center) {
        return (top.equals(ItemStack.field_190927_a) || this.top != null && this.top.test(ccp, (Object)top)) && (bot.equals(ItemStack.field_190927_a) || this.bot != null && this.bot.test(ccp, (Object)bot)) && (lef.equals(ItemStack.field_190927_a) || this.lef != null && this.lef.test(ccp, (Object)lef)) && (rig.equals(ItemStack.field_190927_a) || this.rig != null && this.rig.test(ccp, (Object)rig)) && (center.equals(ItemStack.field_190927_a) || this.center.test(ccp, (Object)center));
    }

    public boolean testInputs(ConditionContainerProvider ccp, ItemStack top, ItemStack bot, ItemStack lef, ItemStack rig, ItemStack center) {
        if (this.top != null && !this.top.test(ccp, (Object)top)) {
            return false;
        }
        if (this.bot != null && !this.bot.test(ccp, (Object)bot)) {
            return false;
        }
        if (this.lef != null && !this.lef.test(ccp, (Object)lef)) {
            return false;
        }
        if (this.rig != null && !this.rig.test(ccp, (Object)rig)) {
            return false;
        }
        return this.center.test(ccp, (Object)center);
    }

    public boolean shouldMergeCenterNBT() {
        return this.mergeNBT;
    }

    public ItemStack getOutput(ConditionContainerProvider ccp) {
        return (ItemStack)this.output.request(ccp).iterator().next();
    }

    public boolean hasInput(int i) {
        switch (i) {
            case 0: {
                return this.top != null;
            }
            case 1: {
                return this.bot != null;
            }
            case 2: {
                return this.lef != null;
            }
            case 3: {
                return this.rig != null;
            }
        }
        return false;
    }

    public int getInputCount(ConditionContainerProvider conditionProvider, int i) {
        switch (i) {
            case 0: {
                return this.top == null ? 0 : this.top.requestAmount(conditionProvider);
            }
            case 1: {
                return this.bot == null ? 0 : this.bot.requestAmount(conditionProvider);
            }
            case 2: {
                return this.lef == null ? 0 : this.lef.requestAmount(conditionProvider);
            }
            case 3: {
                return this.rig == null ? 0 : this.rig.requestAmount(conditionProvider);
            }
            case 4: {
                return this.center.requestAmount(conditionProvider);
            }
        }
        return 0;
    }

    public int getDuration(ConditionContainerProvider conditionProvider) {
        return (Integer)this.duration.request(conditionProvider);
    }

    public List<List<ItemStack>> getAllInputs(ConditionContainerProvider cdp) {
        ArrayList items = Lists.newArrayList();
        items.add(this.top != null ? this.top.request(cdp) : Lists.newArrayList());
        items.add(this.bot != null ? this.bot.request(cdp) : Lists.newArrayList());
        items.add(this.lef != null ? this.lef.request(cdp) : Lists.newArrayList());
        items.add(this.rig != null ? this.rig.request(cdp) : Lists.newArrayList());
        items.add(this.center.request(cdp));
        return items;
    }

    public boolean isPossibleInput(ConditionContainerProvider cdp, ItemStack stack) {
        if (this.top != null && this.top.test(cdp, (Object)stack)) {
            return true;
        }
        if (this.bot != null && this.bot.test(cdp, (Object)stack)) {
            return true;
        }
        if (this.lef != null && this.lef.test(cdp, (Object)stack)) {
            return true;
        }
        if (this.rig != null && this.rig.test(cdp, (Object)stack)) {
            return true;
        }
        return this.center.test(cdp, (Object)stack);
    }

    public boolean isPossibleOut(ConditionContainerProvider cdp, ItemStack out) {
        return this.output.test(cdp, (Object)out);
    }
}

