/*
 * Decompiled with CFR 0.152.
 */
package com.logisticscraft.occlusionculling;

import com.logisticscraft.occlusionculling.DataProvider;
import com.logisticscraft.occlusionculling.cache.ArrayOcclusionCache;
import com.logisticscraft.occlusionculling.cache.OcclusionCache;
import com.logisticscraft.occlusionculling.util.MathUtilities;
import com.logisticscraft.occlusionculling.util.Vec3d;
import java.util.BitSet;

public class OcclusionCullingInstance {
    private final int reach;
    private final double aabbExpansion;
    private final DataProvider provider;
    private final OcclusionCache cache;
    private final BitSet skipList = new BitSet();
    private final boolean[] onFaceEdge = new boolean[6];
    private final Vec3d[] targetPoints = new Vec3d[8];
    private final Vec3d targetPos = new Vec3d(0.0, 0.0, 0.0);
    private final int[] cameraPos = new int[3];

    public OcclusionCullingInstance(int maxDistance, DataProvider provider) {
        this(maxDistance, provider, new ArrayOcclusionCache(maxDistance), 0.5);
    }

    public OcclusionCullingInstance(int maxDistance, DataProvider provider, OcclusionCache cache, double aabbExpansion) {
        this.reach = maxDistance;
        this.provider = provider;
        this.cache = cache;
        this.aabbExpansion = aabbExpansion;
        for (int i = 0; i < this.targetPoints.length; ++i) {
            this.targetPoints[i] = new Vec3d(0.0, 0.0, 0.0);
        }
    }

    public boolean isAABBVisible(Vec3d aabbMin, Vec3d aabbMax, Vec3d viewerPosition) {
        try {
            int z;
            int y;
            int x;
            int maxX = MathUtilities.floor(aabbMax.x + this.aabbExpansion);
            int maxY = MathUtilities.floor(aabbMax.y + this.aabbExpansion);
            int maxZ = MathUtilities.floor(aabbMax.z + this.aabbExpansion);
            int minX = MathUtilities.floor(aabbMin.x - this.aabbExpansion);
            int minY = MathUtilities.floor(aabbMin.y - this.aabbExpansion);
            int minZ = MathUtilities.floor(aabbMin.z - this.aabbExpansion);
            this.cameraPos[0] = MathUtilities.floor(viewerPosition.x);
            this.cameraPos[1] = MathUtilities.floor(viewerPosition.y);
            this.cameraPos[2] = MathUtilities.floor(viewerPosition.z);
            Relative relX = Relative.from(minX, maxX, this.cameraPos[0]);
            Relative relY = Relative.from(minY, maxY, this.cameraPos[1]);
            Relative relZ = Relative.from(minZ, maxZ, this.cameraPos[2]);
            if (relX == Relative.INSIDE && relY == Relative.INSIDE && relZ == Relative.INSIDE) {
                return true;
            }
            this.skipList.clear();
            int id = 0;
            for (x = minX; x <= maxX; ++x) {
                for (y = minY; y <= maxY; ++y) {
                    for (z = minZ; z <= maxZ; ++z) {
                        int cachedValue = this.getCacheValue(x, y, z);
                        if (cachedValue == 1) {
                            return true;
                        }
                        if (cachedValue != 0) {
                            this.skipList.set(id);
                        }
                        ++id;
                    }
                }
            }
            id = 0;
            for (x = minX; x <= maxX; ++x) {
                this.onFaceEdge[0] = x == minX;
                this.onFaceEdge[1] = x == maxX;
                for (y = minY; y <= maxY; ++y) {
                    this.onFaceEdge[2] = y == minY;
                    this.onFaceEdge[3] = y == maxY;
                    for (z = minZ; z <= maxZ; ++z) {
                        this.onFaceEdge[4] = z == minZ;
                        boolean bl = this.onFaceEdge[5] = z == maxZ;
                        if (this.skipList.get(id)) {
                            ++id;
                            continue;
                        }
                        if (this.onFaceEdge[0] && relX == Relative.POSITIVE || this.onFaceEdge[1] && relX == Relative.NEGATIVE || this.onFaceEdge[2] && relY == Relative.POSITIVE || this.onFaceEdge[3] && relY == Relative.NEGATIVE || this.onFaceEdge[4] && relZ == Relative.POSITIVE || this.onFaceEdge[5] && relZ == Relative.NEGATIVE) {
                            this.targetPos.set(x, y, z);
                            if (this.isVoxelVisible(viewerPosition, this.targetPos, this.onFaceEdge)) {
                                return true;
                            }
                        }
                        ++id;
                    }
                }
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    private boolean isVoxelVisible(Vec3d viewerPosition, Vec3d position, boolean[] faceEdgeData) {
        int targetSize = 0;
        if (faceEdgeData[0] || faceEdgeData[4] || faceEdgeData[2]) {
            this.targetPoints[targetSize++].setAdd(position, 0.05, 0.05, 0.05);
        }
        if (faceEdgeData[1]) {
            this.targetPoints[targetSize++].setAdd(position, 0.95, 0.05, 0.05);
        }
        if (faceEdgeData[3]) {
            this.targetPoints[targetSize++].setAdd(position, 0.05, 0.95, 0.05);
        }
        if (faceEdgeData[5]) {
            this.targetPoints[targetSize++].setAdd(position, 0.05, 0.05, 0.95);
        }
        if (faceEdgeData[4] && faceEdgeData[1] && faceEdgeData[3] || faceEdgeData[1] && faceEdgeData[3]) {
            this.targetPoints[targetSize++].setAdd(position, 0.95, 0.95, 0.05);
        }
        if (faceEdgeData[0] && faceEdgeData[5] && faceEdgeData[3] || faceEdgeData[5] && faceEdgeData[3]) {
            this.targetPoints[targetSize++].setAdd(position, 0.05, 0.95, 0.95);
        }
        if (faceEdgeData[5] && faceEdgeData[1]) {
            this.targetPoints[targetSize++].setAdd(position, 0.95, 0.05, 0.95);
        }
        if (faceEdgeData[1] && faceEdgeData[3] && faceEdgeData[5]) {
            this.targetPoints[targetSize++].setAdd(position, 0.95, 0.95, 0.95);
        }
        return this.isVisible(viewerPosition, this.targetPoints, targetSize);
    }

    private boolean isVisible(Vec3d start, Vec3d[] targets, int size) {
        int x = this.cameraPos[0];
        int y = this.cameraPos[1];
        int z = this.cameraPos[2];
        for (int v = 0; v < size; ++v) {
            double t_next_z;
            int z_inc;
            double t_next_y;
            int y_inc;
            double t_next_x;
            int x_inc;
            Vec3d target = targets[v];
            double relativeX = start.x - target.getX();
            double relativeY = start.y - target.getY();
            double relativeZ = start.z - target.getZ();
            double dimensionX = Math.abs(relativeX);
            double dimensionY = Math.abs(relativeY);
            double dimensionZ = Math.abs(relativeZ);
            double dimFracX = 1.0 / dimensionX;
            double dimFracY = 1.0 / dimensionY;
            double dimFracZ = 1.0 / dimensionZ;
            int intersectCount = 1;
            if (dimensionX == 0.0) {
                x_inc = 0;
                t_next_x = dimFracX;
            } else if (target.x > start.x) {
                x_inc = 1;
                intersectCount += MathUtilities.floor(target.x) - x;
                t_next_x = (float)(((double)(x + 1) - start.x) * dimFracX);
            } else {
                x_inc = -1;
                intersectCount += x - MathUtilities.floor(target.x);
                t_next_x = (float)((start.x - (double)x) * dimFracX);
            }
            if (dimensionY == 0.0) {
                y_inc = 0;
                t_next_y = dimFracY;
            } else if (target.y > start.y) {
                y_inc = 1;
                intersectCount += MathUtilities.floor(target.y) - y;
                t_next_y = (float)(((double)(y + 1) - start.y) * dimFracY);
            } else {
                y_inc = -1;
                intersectCount += y - MathUtilities.floor(target.y);
                t_next_y = (float)((start.y - (double)y) * dimFracY);
            }
            if (dimensionZ == 0.0) {
                z_inc = 0;
                t_next_z = dimFracZ;
            } else if (target.z > start.z) {
                z_inc = 1;
                intersectCount += MathUtilities.floor(target.z) - z;
                t_next_z = (float)(((double)(z + 1) - start.z) * dimFracZ);
            } else {
                z_inc = -1;
                intersectCount += z - MathUtilities.floor(target.z);
                t_next_z = (float)((start.z - (double)z) * dimFracZ);
            }
            boolean finished = this.stepRay(start, x, y, z, dimFracX, dimFracY, dimFracZ, intersectCount, x_inc, y_inc, z_inc, t_next_y, t_next_x, t_next_z);
            this.provider.cleanup();
            if (!finished) continue;
            this.cacheResult(targets[0], true);
            return true;
        }
        this.cacheResult(targets[0], false);
        return false;
    }

    private boolean stepRay(Vec3d start, int currentX, int currentY, int currentZ, double distInX, double distInY, double distInZ, int n, int x_inc, int y_inc, int z_inc, double t_next_y, double t_next_x, double t_next_z) {
        while (n > 1) {
            int cVal = this.getCacheValue(currentX, currentY, currentZ);
            if (cVal == 2) {
                return false;
            }
            if (cVal == 0) {
                int chunkX = currentX >> 4;
                int chunkZ = currentZ >> 4;
                if (!this.provider.prepareChunk(chunkX, chunkZ)) {
                    return false;
                }
                if (this.provider.isOpaqueFullCube(currentX, currentY, currentZ)) {
                    this.cache.setLastHidden();
                    return false;
                }
                this.cache.setLastVisible();
            }
            if (t_next_y < t_next_x && t_next_y < t_next_z) {
                currentY += y_inc;
                t_next_y += distInY;
            } else if (t_next_x < t_next_y && t_next_x < t_next_z) {
                currentX += x_inc;
                t_next_x += distInX;
            } else {
                currentZ += z_inc;
                t_next_z += distInZ;
            }
            --n;
        }
        return true;
    }

    private int getCacheValue(int x, int y, int z) {
        if (Math.abs(x -= this.cameraPos[0]) > this.reach - 2 || Math.abs(y -= this.cameraPos[1]) > this.reach - 2 || Math.abs(z -= this.cameraPos[2]) > this.reach - 2) {
            return -1;
        }
        return this.cache.getState(x + this.reach, y + this.reach, z + this.reach);
    }

    private void cacheResult(int x, int y, int z, boolean result) {
        int cx = x - this.cameraPos[0] + this.reach;
        int cy = y - this.cameraPos[1] + this.reach;
        int cz = z - this.cameraPos[2] + this.reach;
        if (result) {
            this.cache.setVisible(cx, cy, cz);
        } else {
            this.cache.setHidden(cx, cy, cz);
        }
    }

    private void cacheResult(Vec3d vector, boolean result) {
        int cx = MathUtilities.floor(vector.x) - this.cameraPos[0] + this.reach;
        int cy = MathUtilities.floor(vector.y) - this.cameraPos[1] + this.reach;
        int cz = MathUtilities.floor(vector.z) - this.cameraPos[2] + this.reach;
        if (result) {
            this.cache.setVisible(cx, cy, cz);
        } else {
            this.cache.setHidden(cx, cy, cz);
        }
    }

    public void resetCache() {
        this.cache.resetCache();
    }

    private static enum Relative {
        INSIDE,
        POSITIVE,
        NEGATIVE;


        public static Relative from(int min, int max, int pos) {
            if (max > pos && min > pos) {
                return POSITIVE;
            }
            if (min < pos && max < pos) {
                return NEGATIVE;
            }
            return INSIDE;
        }
    }
}

